% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{leave_votes_west}
\alias{leave_votes_west}
\title{A tibble with leave votes from the Brexit referendum in each constituency.}
\format{A tibble, with 650 rows and 8 columns.
\describe{
\item{\code{ons_const_id}}{ONS code for constituency}
\item{\code{constituency_name}}{The name of the constituency.}
\item{\code{party_2016}}{The party holding the constituency on 23 June 2016,
the date of the referendum.}
\item{\code{ch_leave_vote}}{Estimates of the leave vote produced by
Chris Hanretty.}
\item{\code{known_leave_vote_perc}}{The percentage of votes cast for leave,
if known.}
\item{\code{how_do_we_know}}{A character vector indicating the source of
known constituency level Brexit votes. "Rosenbaum / Greenwood" refers to
\href{https://www.bbc.co.uk/news/uk-politics-38762034}{BBC reporting}.}
\item{\code{figure_to_use}}{Actual leave vote, where known, and
\code{ch_leave_vote} otherwise.}
#' \item{\code{known_leave_vote}}{A dummy variable indicating 'Yes' if the
actual leave vote percentage is known, and 'No' if only the estimate by
Chris Hanretty is available.}
}}
\source{
Hanretty, C. (2017). Areal interpolation and the UK’s referendum on EU
membership. \emph{Journal of Elections, Public Opinion and Parties}, 27(4),
466–483. \url{https://doi.org/10.1080/17457289.2017.1287081}

\url{https://docs.google.com/spreadsheets/d/1b71SDKPFbk-ktmUTXmDpUP5PT299qq24orEA0_TOpmw/edit#gid=579044181}

\url{http://www.bbc.co.uk/news/uk-northern-ireland-36616830}
}
\usage{
leave_votes_west
}
\description{
A tibble with details on percentage of votes cast for leave in the 2016
referendum on British membership of the European Union in each
constituency. Numbers for Britian were compiled by the House of Commons
using data from Chris Hanretty's estimates of leave vote, and supplemented
with data from BBC Freedom of Information requests for more finely grained
voting data. Numbers for Northern Ireland, which reported results by
constituency, are taken from the BBC.
}
\keyword{datasets}
