% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_utils.R
\name{lodPeaks}
\alias{lodPeaks}
\alias{peakSummary}
\title{LOD score peaks}
\usage{
lodPeaks(x, threshold, width = 1)

peakSummary(x, threshold, width = 1, physmap = NULL)
}
\arguments{
\item{x}{A \link{linkres} object, or data frame with columns \code{CHROM}, \code{MB}, \code{LOD}.}

\item{threshold}{A single number}

\item{width}{A positive integer}

\item{physmap}{A matrix or data frame with three columns: Marker
name, chromosome and physical position.}
}
\value{
A list of data frames.
}
\description{
Identify and summarise LOD score peaks.
}
\details{
A peak is defined as a run of at least \code{width} consecutive markers with LOD
score above or equal to \code{threshold}. If possible, one flanking marker is
included on each side of the peak.
}
\examples{

# Use built-in dataset `dominant1`
lods = lod(x = dominant1$ped,
           aff = dominant1$aff,
           model = diseaseModel("AD"))

# All peaks above LOD = 1.5
lodPeaks(lods, threshold = 1.5)
peakSummary(lods, threshold = 1.5)

}
\seealso{
\link{linkres}, \code{\link[=lod]{lod()}}, \code{\link[=merlinLod]{merlinLod()}}
}
