% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSim.R
\name{simpleSim}
\alias{simpleSim}
\title{Unconditional marker simulation}
\usage{
simpleSim(
  x,
  N,
  alleles,
  afreq,
  available,
  Xchrom = FALSE,
  mutmat = NULL,
  seed = NULL,
  verbose = T
)
}
\arguments{
\item{x}{a \code{\link{linkdat}} object}

\item{N}{a positive integer: the number of markers to be simulated}

\item{alleles}{a vector containing the allele names. If missing, the alleles
are taken to be \code{seq_along(afreq)}.}

\item{afreq}{a vector of length 2 containing the population frequencies for
the alleles. If missing, the alleles are assumed equifrequent.}

\item{available}{a vector containing IDs of the available individuals, i.e.
those whose genotypes should be simulated.}

\item{Xchrom}{a logical: X linked markers or not?}

\item{mutmat}{a mutation matrix, or a list of two such matrices named
'female' and 'male'. The matrix/matrices must be square, with the allele
labels as dimnames, and each row must sum to 1 (after rounding to 3
decimals).}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{verbose}{a logical.}
}
\value{
a \code{linkdat} object equal to \code{x} in all respects except its
  \code{markerdata} entry, which consists of the \code{N} simulated markers.
}
\description{
Unconditional simulation of unlinked markers
}
\details{
This simulation is done by distributing alleles randomly to all founders,
followed by unconditional gene dropping down throughout the pedigree (i.e.
for each non-founder a random allele is selected from each of the parents).
Finally the genotypes of any individuals not included in \code{available} are
removed.
}
\examples{

x = nuclearPed(1)
simpleSim(x, N=3, afreq=c(0.5, 0.5))

y = addOffspring(cousinPed(1), father=7, mother=8, noffs=1)
simpleSim(y, N=3, alleles=LETTERS[1:10])

}
\seealso{
\code{\link{markerSim}}, \code{\link{linkageSim}}
}
