\name{linkageSim}
\alias{linkageSim}
\title{
Simulate markers linked to a disease locus.
}
\description{
Simulates markers (with up to 4 alleles) conditional on the pedigree structure, affection statuses and disease model.
}
\usage{
linkageSim(x, N=1, available=x$available, afreq=NULL, partialmarker=NULL, 
           loop_breakers=NULL, unique=FALSE, seed=NULL, verbose=TRUE)
}
\arguments{
  \item{x}{
a \code{\link{linkdat}} object
}
  \item{N}{
a positive integer: the number of markers to be simulated
}
  \item{partialmarker}{
Either NULL (indicating no given marker data), or a \code{marker} object. 
}
 \item{available}{
a vector containing IDs of the available individuals, i.e. those whose genotypes should be simulated.
}
 \item{afreq}{
a vector of length < 5 containing the population frequencies for the marker alleles.
}
 \item{loop_breakers}{
a numeric containing IDs of individuals to be used as loop breakers. Relevant only if the pedigree has loops. See \code{\link{breakLoops}}.
}
  \item{unique}{
a logical indicating if duplicates among the simulated markers should be removed. 
}
  \item{seed}{
NULL, or a numeric seed for the random number generator. 
}
  \item{verbose}{
a logical. 
}

}
\details{
All markers are simulated under the condition that the recombination fraction between the marker and the disease locus is 0. 
This is an implementation of the algorithm used in SLINK of the LINKAGE/FASTLINK suite.
}
\value{
a \code{linkdat} object equal to \code{x} except its \code{markerdata} entry, which consists of the \code{N} simulated markers.
}
\author{
Magnus Dehli Vigeland
}
\seealso{
\code{\link{linkage.power}}
}
\references{
G. M. Lathrop, J.-M. Lalouel, C. Julier, and J. Ott, \emph{Strategies for Multilocus Analysis in Humans}, 
PNAS 81(1984), pp. 3443-3446.
}
\examples{
data(toyped)
x = linkdat(toyped, model=1)
y = linkageSim(x, N=10, afreq=c(0.5, 0.5))
stopifnot(length(mendelianCheck(y))==0)

z = addOffspring(cousinPed(1), father=7, mother=8, noffs=1, aff=2)
z = setModel(z, 2)
linkageSim(z, N=1, afreq = c(0.1, 0.2, 0.7), loop_breakers=7)


}
\keyword{ datagen }

