% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value_mfx.R
\name{p_value.poissonmfx}
\alias{p_value.poissonmfx}
\alias{p_value.betaor}
\alias{p_value.betamfx}
\title{p-values for Marginal Effects Models}
\usage{
\method{p_value}{poissonmfx}(model, component = c("all", "conditional", "marginal"), ...)

\method{p_value}{betaor}(model, component = c("all", "conditional", "precision"), ...)

\method{p_value}{betamfx}(
  model,
  component = c("all", "conditional", "precision", "marginal"),
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{component}{Should all parameters, parameters for the conditional model, precision-component or marginal effects be returned? \code{component} may be one of \code{"conditional"}, \code{"precision"}, \code{"marginal"} or \code{"all"} (default).}

\item{...}{Currently not used.}
}
\value{
A data frame with at least two columns: the parameter names and the p-values. Depending on the model, may also include columns for model components etc.
}
\description{
This function attempts to return, or compute, p-values of marginal effects models from package \pkg{mfx}.
}
\examples{
if (require("mfx")) {
  set.seed(12345)
  n <- 1000
  x <- rnorm(n)
  y <- rnegbin(n, mu = exp(1 + 0.5 * x), theta = 0.5)
  d <- data.frame(y, x)
  model <- poissonmfx(y ~ x, data = d)

  p_value(model)
  p_value(model, component = "marginal")
}
}
