% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setContinuousColorScale}
\alias{setContinuousColorScale}
\title{Traces colors}
\usage{
setContinuousColorScale(id, continuousCsId)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{continuousCsId}{one of the available color scale ids}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which color scale to use when reference column is of type continuous.
}
\details{
If a column is defined as the reference (for example by clicking on its header), a color scale is associated to this column.
Available color scale ids are: `Blues`, `RdBu`, `YlGnBu`, `YlOrRd`, `Reds`.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       selectInput("continuousCsSelect", "Continuous Color Scale:", 
           choices = list("Blues" = "Blues", "RdBu" = "RdBu", "YlGnBu" = "YlGnBu", 
                           "YlOrRd" = "YlOrRd", "Reds" = "Reds"), selected = "Blues"),
       p("The selector controls the colors used when reference column is of type continuous"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(iris, refColumnDim = "Sepal.Length")
       })
       observeEvent(input$continuousCsSelect, {
           parallelPlot::setContinuousColorScale("parPlot", input$continuousCsSelect)
       })
   }

   shinyApp(ui, server)
 }

}
