% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sampler1D.R
\docType{data}
\name{Sampler1DNormal}
\alias{Sampler1DNormal}
\title{Sampler1DNormal Class}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Sampler1D}.}
\description{
Normal sampling (potentially truncated) for \link{ParamDbl}.
}
\section{Construction}{
\preformatted{smpl = Sampler1DNormal$new(param, mean = NULL, sd = NULL)
}
\itemize{
\item \code{mean} :: \code{numeric(1)}\cr
Mean parameter of the normal distribution.
Default is \code{mean(c(param$lower, param$upper)}.
\item \code{sd} :: \code{numeric(1)}\cr
SD parameter of the normal distribution.
Default is \code{(param$upper - param$lower)/4}.
}
}

\section{Fields}{

See \link{Sampler1D}.
Additionally, the class provides:
\itemize{
\item \code{mean} :: \code{numeric(1)}\cr
Mean parameter of the normal distribution.
Default is \code{mean(c(param$lower, param$upper)}.
\item \code{sd} :: \code{numeric(1)}\cr
SD parameter of the normal distribution.
Default is \code{(param$upper - param$lower)/4}.
}
}

\section{Methods}{

See \link{Sampler1D}.
}

\seealso{
Other Sampler: \code{\link{Sampler1DCateg}},
  \code{\link{Sampler1DRfun}}, \code{\link{Sampler1DUnif}},
  \code{\link{Sampler1D}},
  \code{\link{SamplerHierarchical}},
  \code{\link{SamplerJointIndep}},
  \code{\link{SamplerUnif}}, \code{\link{Sampler}}
}
\concept{Sampler}
\keyword{datasets}
