% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_data.R
\name{are_varying}
\alias{are_varying}
\title{Check if variables are constant or variable over time.}
\usage{
are_varying(data, ..., type = "time")
}
\arguments{
\item{data}{A data frame, typically of \code{\link[=panel_data]{panel_data()}} class.}

\item{...}{Variable names. If none are given, all variables are checked.}

\item{type}{Check for variance over time or across individuals? Default
is \code{"time"}. \code{"individual"} considers variables like age to be non-varying
because everyone ages at the same speed.}
}
\value{
A named logical vector. If TRUE, the variable is varying.
}
\description{
This function is designed for use with \code{\link[=panel_data]{panel_data()}} objects.
}
\examples{

wages <- panel_data(WageData, id = id, wave = t)
wages \%>\% are_varying(occ, ind, fem, blk)

}
