% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-ns.r
\name{boot.palm}
\alias{boot.palm}
\title{Bootstrapping for fitted models}
\usage{
boot.palm(fit, N, prog = TRUE)
}
\arguments{
\item{fit}{A fitted object.}

\item{N}{The number of bootstrap resamples.}

\item{prog}{Logical, if \code{TRUE}, a progress bar is printed to
the console.}
}
\value{
The original model object containing additional information
    from the bootstrap procedure. These are accessed by functions
    such as \link{summary.palm} and \link{confint.palm}. The
    bootstrap parameter estimates can be found in the \code{boots}
    component of the returned object.
}
\description{
Carries out a parametric bootstrap procedure for models fitted
using the \code{palm} package.
}
\examples{
## Fit model.
fit <- fit.ns(example.2D, lims = rbind(c(0, 1), c(0, 1)), R = 0.5)
## Carry out bootstrap.
fit <- boot.palm(fit, N = 100)
## Inspect standard errors and confidence intervals.
summary(fit)
confint(fit)
## Estimates are very imprecise---these data were only used as
## they can be fitted and bootstrapped quickly for example purposes.

}
