% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTraitgram.R
\name{plotTraitgram}
\alias{plotTraitgram}
\title{Plot a Traitgram for Continuous Traits}
\usage{
plotTraitgram(trait, tree, main = "", conf.int = TRUE, lwd = 1.5)
}
\arguments{
\item{trait}{A vector of continuous trait values. If the length of \code{trait}
is equal to the number of tips and number of nodes, than it is presumed internal
node values are given. If the length of \code{trait} is equal to the number of tips
of \code{tree} then these will be treated as tip values and ancestral trait reconstruction
will be used to reconstruct the missing ancestral values. If \code{trait} is not
named, or if internal node values are given, then values will be presumed to be in
the order of tip/node numbering in \code{tree$edge}, which for tips is the same as
the ordering in \code{tree$tip.label}.}

\item{tree}{A \code{phylo} object.}

\item{main}{Main title of traitgram plot.}

\item{conf.int}{If \code{TRUE} (the default), confidence intervals are plotted.}

\item{lwd}{The line width used for branches in the figure.}
}
\value{
Return no value, just plot the traitgram.
}
\description{
\code{plotTraitgram} plots a traitgram showing the evolution of a continuous trait.
If node values are not given (i.e. the data is empirical data collected from tips,
rather than simulated data), maximum-likelihood ancestral trait estimation is used
to calculate node values. (Ackerly, 2009) given a tree and a set of continuous trait
values.
}
\details{
By default, this function will use \code{\link{ace}} from the library \code{ape} to
reconstruct ancestral traits and confidence intervals using the PIC method, if internal
node values (i.e. ancestral node values) are not given.

As with many functions in the paleotree library, absolute time is always
decreasing, i.e. the present day is zero.
}
\note{
One should probably never do ancestral trait estimation without
looking at the confidence intervals, as these reconstructed estimates tend
to be very uncertain.
}
\examples{

set.seed(444)
tree <- rtree(10)
trait <- rTraitCont(tree)

#first, traitgram without conf intervals
plotTraitgram(trait,tree,conf.int = FALSE)

#now, with
plotTraitgram(trait,tree)
#not much confidence, eh?

# plotting simulated data
    # with values for ancestral nodes as input
trait <- rTraitCont(tree, ancestor = TRUE)
plotTraitgram(tree = tree,trait = trait)

}
\references{
Ackerly, D. 2009 Conservatism and diversification of plant
functional traits: Evolutionary rates versus phylogenetic signal.
\emph{Proceedings of the National Academy of Sciences} \bold{106}(Supplement
2):19699--19706.
}
\seealso{
\code{\link{ace}}

Also see the functions \code{traitgram} in the library picante and
\code{phenogram} in the library phytools.
}
\author{
David W. Bapst
}
