% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largeVis.R
\name{buildWijMatrix}
\alias{buildWijMatrix}
\title{Rescale the weights in an edge matrix to match a given perplexity.
From 'largeVis', <https://github.com/elbamos/largeVis>}
\usage{
buildWijMatrix(x, threads = NULL, perplexity = 50)
}
\arguments{
\item{x}{An edgematrix, either an `edgematrix` object or a sparse matrix.}

\item{threads}{numeric The maximum number of threads to spawn (default=NULL). Determined automatically if NULL (default=NULL)}

\item{perplexity}{numeric Given perplexity (default=50)}
}
\value{
A \code{list} with the following components: \describe{
   \item{'dist'}{An [N,K] matrix of the distances to the nearest neighbors.}
   \item{'id'}{An [N,K] matrix of the node indexes of the neartest neighbors.  Note that this matrix is 1-indexed,
   unlike most other matrices in this package.}
   \item{'k'}{The number of nearest neighbors.}
 }
}
\description{
Rescale the weights in an edge matrix to match a given perplexity.
From 'largeVis', <https://github.com/elbamos/largeVis>
}
