% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestamps.R
\name{pageview_timestamps}
\alias{pageview_timestamps}
\title{Convert time objects to function with pageviews functions}
\usage{
pageview_timestamps(timestamps = Sys.Date(), first = TRUE)
}
\arguments{
\item{timestamps}{a vector of Date, POSIXlt or POSIXct objects.}

\item{first}{whether to, if \code{timestamps} is of date objects, assume the
first hour in a day (TRUE) or the last (FALSE). TRUE by default.}
}
\value{
a character vector containing timestamps that can be used with \code{\link{article_pageviews}} et al.
}
\description{
\code{pageview_timestamps} converts \code{\link{Date}} and \code{\link{POSIXlt}} and ct
objects to work nicely with the \code{start} and \code{end} parameters in pageviews functions.
}
\examples{
# Using a Date
pageview_timestamps(Sys.Date())

# Using a POSIXct object
pageview_timestamps(Sys.time())

}
\seealso{
\code{\link{article_pageviews}} and \code{\link{project_pageviews}}, where you
can make use of this function.
}

