% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{Show differences between the last snapshot and the library}
\usage{
status(project = NULL, lib.loc = libDir(project), quiet = FALSE)
}
\arguments{
\item{project}{The directory that contains the R project.}

\item{lib.loc}{The library to examine. Defaults to the private library
associated with the project directory.}

\item{quiet}{Print detailed information about the packrat status to the console?}
}
\value{
Either \code{NULL} if a \code{packrat} project has not yet been
initialized, or a (invisibly) a \code{data.frame} with components:
\item{package}{The package name,}
\item{packrat.version}{The package version used in the last snapshot,}
\item{packrat.source}{The location from which the package was obtained,}
\item{library.version}{The package version available in the local library,}
\item{currently.used}{Whether the package is used in any of the R code in the current project.}
}
\description{
Shows the differences between the project's packrat dependencies, its private
package library, and its R scripts.
}
\details{
These differences are created when you use the normal R package management
commands like \code{\link{install.packages}}, \code{\link{update.packages}},
and \code{\link{remove.packages}}. To bring these differences into packrat, you
can use \code{\link{snapshot}}.

Differences can also arise if one of your collaborators adds or removes
packages from the packrat dependencies. In this case, you simply need to tell
packrat to update your private package library using \code{\link{restore}}.
}

