% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_archive}
\alias{check_archive}
\alias{check_archive_as_cran}
\title{Check a Package Archive}
\usage{
check_archive(path, cmdargs = NULL)

check_archive_as_cran(path)
}
\arguments{
\item{path}{Path to the package archive.}

\item{cmdargs}{Command line arguments (see
\code{\link[callr:rcmd]{callr::rcmd}}).}
}
\value{
A list with standard output, standard error
and exit status of the check
(see \code{\link[callr:rcmd]{callr::rcmd}}).
}
\description{
This is a wrapper to
\code{\link[callr:rcmd_safe]{callr::rcmd_safe}("check")},
similar to, but leaner than
\code{\link[rcmdcheck:rcmdcheck]{rcmdcheck::rcmdcheck}}. While
the latter parses the output of \code{rcmd_safe} and uses
\pkg{clisymbols} in the callback, we here just return bare output and use
\code{\link{writeLines}} as callback. This should result in a screen display
that is identical to the output of \command{R CMD check}.
}
\note{
\code{check_archive_as_cran} is a convenience Wrapper to
\code{check_archive}.
}
\examples{
\dontrun{
package_path <- file.path(tempdir(), "fakepack")
usethis::create_package(path = package_path)
file.copy(system.file("templates", "throw.R", package = "fakemake"),
          file.path(package_path, "R"))
roxygen2::roxygenize(package_path)
print(tarball <- get_pkg_archive_path(package_path))
devtools::build(pkg = package_path, path = package_path)
print(check_archive(tarball))
}
}
\seealso{
Other maintenance functions: 
\code{\link{check_codetags}()},
\code{\link{check_cyclomatic_complexity}()},
\code{\link{check_news}()},
\code{\link{check_usage}()},
\code{\link{get_check_status}()}

Other maintenance functions: 
\code{\link{check_codetags}()},
\code{\link{check_cyclomatic_complexity}()},
\code{\link{check_news}()},
\code{\link{check_usage}()},
\code{\link{get_check_status}()}
}
\concept{maintenance functions}
