% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b_outcome_analysis_functions.R
\name{value_promis3a_scores_IPD}
\alias{value_promis3a_scores_IPD}
\title{Function to convert promis3a scores to a T score}
\usage{
value_promis3a_scores_IPD(
  ind_part_data,
  promis3a_related_words,
  promis3a_nrcode,
  promis3a_scoring_table = NULL
)
}
\arguments{
\item{ind_part_data}{a data frame containing IPD data}

\item{promis3a_related_words}{related words to find out which columns
contain promis3a data}

\item{promis3a_nrcode}{non response code for promis3a}

\item{promis3a_scoring_table}{promis3a scoring table, if given as NULL use
the default one}
}
\value{
promis3a scores converted to T score included modified data, if
success -1, if failure
}
\description{
Function to convert promis3a scores to a T score
}
\examples{
trial_data <- data.frame("tpi.q1" = c(1, 2),
"tpi.q2" = c(1, 2), "tpi.q3" = c(1, 2))
results <- value_promis3a_scores_IPD(trial_data, c("tpi"), NA, NULL)
}
