% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/4b_probabilistic_sensitivity_analysis_functions.R
\name{list_paramwise_psa_result}
\alias{list_paramwise_psa_result}
\title{Function to list probabilistic sensitivity analysis results parameterwise}
\usage{
list_paramwise_psa_result(
  result_psa_params_control,
  result_psa_params_treat,
  threshold,
  comparator
)
}
\arguments{
\item{result_psa_params_control}{result from probabilistic
sensitivity analysis for first or control model}

\item{result_psa_params_treat}{result from probabilistic sensitivity
analysis for the comparative Markov model}

\item{threshold}{threshold value of WTP}

\item{comparator}{the strategy to be compared with}
}
\value{
plot of  sensitivity analysis
}
\description{
Function to list probabilistic sensitivity analysis results parameterwise
}
\examples{
\donttest{
param_list <- define_parameters(
  cost_zido = 2278, cost_direct_med_A = 1701,
  cost_comm_care_A = 1055, cost_direct_med_B = 1774,
  cost_comm_care_B = 1278,
  cost_direct_med_C = 6948, cost_comm_care_C = 2059,
  tpAtoA = 1251 / (1251 + 483),
  tpAtoB = 350 / (350 + 1384), tpAtoC = 116 / (116 + 1618),
  tpAtoD = 17 / (17 + 1717),
  tpBtoB = 731 / (731 + 527), tpBtoC = 512 / (512 + 746),
  tpBtoD = 15 / (15 + 1243),
  tpCtoC = 1312 / (1312 + 437), tpCtoD = 437 / (437 + 1312), tpDtoD = 1,
  cost_health_A = "cost_direct_med_A + cost_comm_care_A",
  cost_health_B = "cost_direct_med_B + cost_comm_care_B",
  cost_health_C = "cost_direct_med_C + cost_comm_care_C",
  cost_drug = "cost_zido"
)
A <- health_state("A", cost = "cost_health_A + cost_drug ", utility = 1)
B <- health_state("B", cost = "cost_health_B + cost_drug", utility = 1)
C <- health_state("C", cost = "cost_health_C + cost_drug", utility = 1)
D <- health_state("D", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3, 4), c(NA, 5, 6, 7), c(NA, NA, 8, 9),
c(NA, NA, NA, 10))
colnames(tmat) <- rownames(tmat) <- c("A", "B", "C", "D")
tm <- populate_transition_matrix(4, tmat, c(
  "tpAtoA", "tpAtoB", "tpAtoC", "tpAtoD",
  "tpBtoB", "tpBtoC", "tpBtoD", "tpCtoC", "tpCtoD", "tpDtoD"
), colnames(tmat))
health_states <- combine_state(A, B, C, D)
mono_strategy <- strategy(tm, health_states, "mono")
mono_markov <- markov_model(mono_strategy, 20, initial_state = c(1,0,0,0),
discount = c(0.06, 0),param_list)
sample_list <- define_parameters(cost_zido = "gamma(mean = 2756,
sd = sqrt(2756))")
param_table <- define_parameters_psa(param_list, sample_list)
result <- do_psa(mono_markov, param_table, 10)
list_paramwise_psa_result(result, NULL, NULL, NULL)
}
}
