% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b_outcome_analysis_functions.R
\name{map_eq5d5Lto3L_VanHout}
\alias{map_eq5d5Lto3L_VanHout}
\title{Function to map EQ5D5L scores to EQ5D3L scores and then add to IPD data}
\source{
http://eprints.whiterose.ac.uk/121473/1/Devlin_et_al-2017-Health_Economics.pdf
}
\usage{
map_eq5d5Lto3L_VanHout(ind_part_data, eq5d_nrcode)
}
\arguments{
\item{ind_part_data}{a data frame}

\item{eq5d_nrcode}{non response code for EQ5D5L, default is NA}
}
\value{
qaly included modified data, if success -1, if failure
}
\description{
Function to map EQ5D5L scores to EQ5D3L scores and then add to IPD data
}
\examples{
\donttest{
library(valueEQ5D)
datafile <- system.file("extdata", "trial_data.csv",
package = "packDAMipd")
trial_data <- load_trial_data(datafile)
map_eq5d5Lto3L_VanHout(trial_data, NA)
}
}
