% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2b_parameter_estimation_survival_functions.R
\name{use_survival_analysis}
\alias{use_survival_analysis}
\title{############################################################################
Get the parameter values using the survival analysis}
\usage{
use_survival_analysis(
  param_to_be_estimated,
  dataset,
  indep_var,
  info_get_method,
  info_distribution,
  covariates,
  timevar_survival
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{dataset}{data set to be provided}

\item{indep_var}{the independent variable (column name in data file)}

\item{info_get_method}{additional information on methods e.g
Kaplan-Meier ot hazard}

\item{info_distribution}{distribution name  eg. for logistic
regression -binomial}

\item{covariates}{list of covariates - calculations to be done
before passing}

\item{timevar_survival}{time variable for survival analysis,
default is NA}
}
\value{
the results of the regression analysis
}
\description{
############################################################################
Get the parameter values using the survival analysis
}
\details{
This function helps to get the parameter values after the survival analysis
Takes into account many different methods like KM.FH, Cox proportional etc.
and then calls appropriate functions to do the survival analysis
}
\examples{
\donttest{
data_for_survival <- survival::aml
surv_estimated_aml <- use_survival_analysis("status", data_for_survival,
  "x",
  info_get_method = "parametric", info_distribution = "weibull",
  covariates = NA, "time")
}
}
