% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{health_state}
\alias{health_state}
\title{Definition of health state class or health state constructor}
\usage{
health_state(name, cost, utility, state_time = 0, absorb = FALSE)
}
\arguments{
\item{name}{name of the health state}

\item{cost}{value or expression that represents cost of the health state}

\item{utility}{value or expression that represents utility
of the health state}

\item{state_time}{time denoting how long in the state}

\item{absorb}{boolean indicating health state absorbing or not}
}
\value{
value of the state
}
\description{
Definition of health state class or health state constructor
}
\details{
Initialising the name, cost, utility and time spent for the health state
name is the name of the health state
cost/utility can be defined as characters e.g. "cost_A"
if they are characters, the value is assigned after parsing the text.
state_time is integer and absorb is boolean
}
\examples{
st <- health_state("IT", 100, 0.4, 0, FALSE)
st <- health_state("IT", "cost_A", 0.4, 0, FALSE)
}
