% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\alias{plot_heatmap,Raster-method}
\alias{plot_heatmap,data.table-method}
\alias{plot_heatmap,character-method}
\title{Heatmap ggplot}
\usage{
plot_heatmap(x, unit = "mm")

\S4method{plot_heatmap}{Raster}(x, unit = "mm")

\S4method{plot_heatmap}{data.table}(x, unit = "mm")

\S4method{plot_heatmap}{character}(x, unit = "mm")
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character, see details)}

\item{unit}{character (see details)}
}
\value{
ggplot object
}
\description{
Convenient and aesthetic visualization of data in a heatmap.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.

`unit` is a character string describing the unit of measurement to be used for the axis title
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- plot_heatmap(r)
}
}
