% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{label}
\alias{label}
\title{Labeling}
\usage{
label(x, y)
}
\arguments{
\item{x}{data.table (see details)}

\item{y}{character (see details)}
}
\value{
data.table
}
\description{
The function \code{label} adds data set name and source type.
}
\details{
columns in `x` should be named (if present): "lon", "lat", "date", and "value"

Available options are:
\itemize{
\item{"20cr" for 20CR v3,}
\item{"chirps" for CHIRPS v2.0,}
\item{"cmap" for CMAP standard version,}
\item{"cmorph" for CMORPH,}
\item{"cpc" for CPC-Global,}
\item{"cru-ts" for CRU_TS v4.06,}
\item{"em-earth" for EM-EARTH,}
\item{"era20c" for ERA-20C,}
\item{"era5" for ERA5,}
\item{"fldas" for FLDAS,}
\item{"ghcn" for GHCN-M v2,}
\item{"gldas-clsm" for GLDAS CLSM,}
\item{"gldas-noah" for GLDAS NOAH,}
\item{"gldas-vic" for GLDAS VIC,}
\item{"gleam" for GLEAM v3.7a,}
\item{"gpcc" for GPCC v2020,}
\item{"gpcp" for GPCP v2.3,}
\item{"gpm_imerg" for GPM IMERGM Final v06,}
\item{"jra55" for JRA-55,}
\item{"merra2" for MERRA-2,}
\item{"mswep" for MSWEP v2.8,}
\item{"ncep-doe" for NCEP/DOE,}
\item{"ncep-ncar" for NCEP/NCAR,}
\item{"persiann" for PERSIANN-CDR,}
\item{"precl" for PREC/L,}
\item{"terraclimate" for TerraClimate,}
\item{"trmm-3b43" for TRMM 3B43 v7,}
\item{"udel" for UDEL v501.}
}
}
\examples{
\dontrun{
r <- data.table::data.table("date" = as.Date("2000-01-01"), "value" = 42)
s <- label(r, "mswep")
}
}
