% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCODE.R
\name{prepare_basis}
\alias{prepare_basis}
\title{Evaluate basis objects over observation times and quadrature points}
\usage{
prepare_basis(basis, times, nquadpts)
}
\arguments{
\item{basis}{A basis object.}

\item{times}{The vector contain observation times for corresponding dimension.}

\item{nquadpts}{Number of quadrature points will be used later for approximating integrals.}
}
\value{
\item{Phi.mat}{Evaluations of all basis functions stored as columns in the matrix.}

\item{Qmat}{Evaluations of all basis functions over quadrature points stored as columns in the matrix.}

\item{Q.D1mat}{Evaluations of first order derivative all basis functions over quadrature points stored as columns in the matrix.}

\item{Q.D2mat}{Evaluations of second order derivative all basis functions over quadrature points stored as columns in the matrix.}

\item{quadts}{Quadrature points.}

\item{quadwts}{Quadrature weights.}
}
\description{
Calculate all basis functions over observation time points and store them as columns in a single matrix for each dimension. Also include first and second order derivative. Repeat over quadrature points.
}
