% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{run_server}
\alias{run_server}
\title{Start local OSRM server}
\usage{
run_server(map_name, osrm_path = Sys.getenv("OSRM_PATH"))
}
\arguments{
\item{map_name}{A character (name of your pre-built map - e.g. "switzerland-latest.osrm")}

\item{osrm_path}{A string pointing to your local OSRM installation. Default is the environment variable "OSRM_PATH".}
}
\value{
error_code A character
}
\description{
run_server() starts your local OSRM server by using a shell command (depending on
your OS). A local (pre-built) version of the OSRM-engine must be on your device.
(https://github.com/Project-OSRM/osrm-backend/wiki/Building-OSRM).
}
\details{
To start the server, it is necessary to know its location. If it was installed
in C:/OSRM_APIx, it is easiest to set an environment variable which points to
the folder via Sys.setenv(). Note: You need to set the variable in each session.
}
\examples{
\dontrun{
Sys.setenv("OSRM_PATH"="C:/OSRM_API4")
osrmr::run_server("switzerland-latest.osrm")
# 0
Sys.setenv("OSRM_PATH"="C:/OSRM_API5")
osrmr::run_server("switzerland-latest.osrm")
# 0
Sys.unsetenv("OSRM_PATH")}
}
