% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-colourbar.R
\name{add_colourbar}
\alias{add_colourbar}
\title{add_colorbar}
\usage{
add_colourbar(map, barwidth = 0.02, barlength = 0.7, zlims, cols,
  vertical = TRUE, alpha = 0.4, text_col = "black", fontsize = 3,
  fontface, fontfamily, ...)
}
\arguments{
\item{map}{A \code{ggplot2} object to which the colourbar is to be added.}

\item{barwidth}{Relative width of the bar (perpendicular to its direction),
either a single number giving distance from right or upper margin, or two
numbers giving left/right or lower/upper limits.}

\item{barlength}{Relative length of the bar (parallel to its direction),
either a single number giving total length of centred bar, or two numbers
giving lower/upper or left/right limits.}

\item{zlims}{Vector of (min,max) values for scale of colourbar. These should
be the values returned from \code{\link{add_osm_surface}}.}

\item{cols}{Vector of colours.}

\item{vertical}{If \code{FALSE}, colourbar is aligned horizontally instead of
default vertical alignment.}

\item{alpha}{Transparency level of region immediately surrounding colourbar,
including behind text. Lower values are more transparent.}

\item{text_col}{Colour of text, tick marks, and lines on colourbar.}

\item{fontsize}{Size of text labels (in \code{ggplot2} terms; default=3).}

\item{fontface}{Fontface for colourbar labels
(1:4=plain,bold,italic,bold-italic).}

\item{fontfamily}{Family of colourbar font (for example, `\code{Times}').}

\item{...}{Mechanism to allow many parameters to be passed with alternative
names (such as \code{xyz} for \code{fontxyz}).}
}
\value{
Modified version of \code{map} with colourbar added.
}
\description{
Adds a colourbar to an existing map. Intended to be used in combination with
\code{\link{add_osm_surface}}. At present, only plots on right side of map.
}
\examples{
bbox <- get_bbox (c (-0.13, 51.5, -0.11, 51.52))
map <- osm_basemap (bbox=bbox, bg="gray20")
# Align volcano data to lat-lon range of bbox
dv <- dim (volcano)
x <- seq (bbox [1,1], bbox [1,2], length.out=dv [1])
y <- seq (bbox [2,1], bbox [2,2], length.out=dv [2])
dat <- data.frame (
                  x=rep (x, dv [2]),
                  y=rep (y, each=dv [1]),
                  z=as.numeric (volcano)
                  )
map <- add_osm_surface (map, obj=london$dat_BNR, dat=dat,
                        cols=heat.colors (30))
map <- add_axes (map)
# Note colours of colourbar can be artibrarily set, and need not equal those
# passed to 'add_osm_surface'
map <- add_colourbar (map, zlims=range (volcano), cols=heat.colors(100),
                      text_col="black")
print_osm_map (map)

# Horizontal colourbar shifted away from margins:
map <- osm_basemap (bbox=bbox, bg="gray20")
map <- add_osm_surface (map, obj=london$dat_BNR, dat=dat,
                        cols=heat.colors (30))
map <- add_colourbar (map, zlims=range (volcano), cols=heat.colors(100),
                      barwidth=c(0.1,0.15), barlength=c(0.5, 0.9), vertical=FALSE)
print_osm_map (map)
}
\seealso{
\code{\link{osm_basemap}}, \code{\link{add_osm_surface}}.
}

