## ----load, include=FALSE-------------------------------------------------
setwd ("../..")
library (devtools)
load_all ("osmplotr")
setwd ("./osmplotr/vignettes")

## ------------------------------------------------------------------------
bbox <- c(-0.15,51.5,-0.1,51.52) 
structures <- c ('highway', 'highway', 'building', 'building', 'building',
                 'amenity', 'grass', 'park', 'natural', 'tree')   
structs <- osm_structures (structures=structures, col_scheme='dark')   
structs$value [1] <- '!primary'   
structs$value [2] <- 'primary'
structs$suffix [2] <- 'HP'
structs$value [3] <- '!residential'
structs$value [4] <- 'residential'
structs$value [5] <- 'commercial'
structs$suffix [3] <- 'BNR'
structs$suffix [4] <- 'BR'
structs$suffix [5] <- 'BC'

## ---- eval=FALSE---------------------------------------------------------
#  london <- list ()
#  for (i in 1:(nrow (structs) - 1))
#  {
#      dat <- extract_osm_objects (key=structs$key [i], value=structs$value [i],
#                                  bbox=bbox)
#      fname <- paste0 ('dat_', structs$suffix [i])
#      assign (fname, dat)
#      london [[i]] <- get (fname)
#      names (london)[i] <- fname
#      rm (list=c(fname))
#  }

## ---- eval=FALSE---------------------------------------------------------
#  extra_pairs <- c ('name', 'Royal.Festival.Hall')
#  london$dat_RFH <- extract_osm_objects (key='building', extra_pairs=extra_pairs,
#                                         bbox=bbox)
#  extra_pairs <- list (c ('addr:street', 'Stamford.St'),
#                       c ('addr:housenumber', '150'))
#  london$dat_ST <- extract_osm_objects (key='building', extra_pairs=extra_pairs,
#                                        bbox=bbox)
#  highways <- c ('Kingsway', 'Holborn', 'Farringdon.St', 'Strand',
#                 'Fleet.St', 'Aldwych')
#  london$highways1 <- highways2polygon (highways=highways, bbox=bbox)
#  highways <- c ('Queen.s.Walk', 'Blackfriars', 'Waterloo', 'The.Cut')
#  london$highways2 <- highways2polygon (highways=highways, bbox=bbox)
#  highways <- c ('Regent.St', 'Oxford.St', 'Shaftesbury')
#  london$highways3 <- highways2polygon (highways=highways, bbox=bbox)

