% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-boundary.R
\name{oe_get_boundary}
\alias{oe_get_boundary}
\title{Get the administrative boundary for a given place}
\usage{
oe_get_boundary(place, name = place, exact = TRUE, ...)
}
\arguments{
\item{place}{Description of the geographical area that should be matched with
a \code{.osm.pbf} file. Can be either a length-1 character vector, an
\code{sf}/\code{sfc}/\code{bbox} object with any CRS, or a numeric vector of coordinates
with length 2. In the last case, it is assumed that the EPSG code is 4326
specified as c(LON, LAT), while you can use any CRS with \code{sf}/\code{sfc}/\code{bbox}
objects. See Details and Examples in \code{\link[=oe_match]{oe_match()}}.}

\item{name}{A character vector of length 1 that describes the relevant area.
By default, this is equal to \code{place}, but this parameter can be tuned to
obtain more granular results starting from the same OSM extract. See
examples. It must be always set when the \code{place} argument is specified
using numeric or spatial objects.}

\item{exact}{Boolean of length 1. If \code{TRUE}, then the function returns only
those features where the field \code{name} is exactly equal to \code{name}. If
\code{FALSE}, it performs a (case-sensitive) pattern matching.}

\item{...}{Further arguments (e.g. \code{quiet} or \code{force_vectortranslate}) that
are passed to \code{oe_get()}.}
}
\value{
An \code{sf} object
}
\description{
This function can be used to obtain polygon/multipolygon objects representing
an administrative boundary. The objects are extracted from the
\code{multipolygons} layer of a given OSM extract.
}
\details{
The function may return an empty result when the corresponding GPKG file
already exists and contains partial results. In that case, you can try
running the function setting \code{never_skip_vectortranslate = TRUE}.
}
\examples{
\dontrun{
library(sf)
my_cols = sf.colors(5, categorical = TRUE)
gabon = oe_get_boundary("Gabon", quiet = TRUE) # country
libreville = oe_get_boundary("Gabon", "Libreville", quiet = TRUE) # capital

opar = par(mar = rep(0, 4))
plot(st_geometry(st_boundary(gabon)), reset = FALSE, col = "grey")
plot(st_geometry(libreville), add = TRUE, col = my_cols[1])

# Exact match
komo = oe_get_boundary("Gabon", "Komo", quiet = TRUE)
# Pattern matching
komo_pt = oe_get_boundary("Gabon", "Komo", exact = FALSE, quiet = TRUE)
plot(st_geometry(komo), add = TRUE, col = my_cols[2])
plot(st_geometry(komo_pt), add = TRUE, col = my_cols[3:5])
par(opar)

# Get all boundaries
(oe_get_boundary("Gabon", name = "\%", exact = FALSE, quiet = TRUE)[, 1:2])

# If the basic approach doesn't work, i.e.
oe_get_boundary("Leeds")

# try to consider larger regions, i.e.
oe_get_boundary("West Yorkshire", "Leeds")
}
}
