% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-extract.R
\name{osm_multipolygons}
\alias{osm_multipolygons}
\title{Extract all \code{osm_multipolygons} from an osmdata object}
\usage{
osm_multipolygons(dat, id)
}
\arguments{
\item{dat}{An object of class \link{osmdata}}

\item{id}{OSM identification of one or more objects for which multipolygons
are to be extracted}
}
\value{
An \pkg{sf} Simple Features Collection of multipolygons
}
\description{
\code{id} must be of an \code{osm_points}, \code{osm_lines}, or
\code{osm_polygons} object. \code{osm_multipolygons} returns any multipolygon
object(s) which contain the object specified by \code{id}.
}
\examples{
\dontrun{
# find all multipolygons which contain the single polygon called
# "Chiswick Eyot" (which is an island).
dat <- opq ("London UK") \%>\%
    add_osm_feature (key = "name", value = "Thames", exact = FALSE) \%>\%
    osmdata_sf ()
index <- which (dat$osm_multipolygons$name == "Chiswick Eyot")
id <- rownames (dat$osm_polygons [id, ])
osm_multipolygons (dat, id)
# That multipolygon is the Thames itself, but note that
nrow (dat$osm_multipolygons) # = 14 multipolygon objects
nrow (osm_multipolygons (dat, id)) # = 1 - the main Thames multipolygon
}
}
\seealso{
Other search: 
\code{\link{osm_lines}()},
\code{\link{osm_multilines}()},
\code{\link{osm_points}()},
\code{\link{osm_polygons}()}
}
\concept{search}
