% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/coerce.R
\docType{methods}
\name{coerce-methods}
\alias{as,array,anlz-method}
\alias{as,array,nifti-method}
\alias{as<-,array,anlz-method}
\alias{as<-,array,nifti-method}
\alias{coerce,anlz,nifti-method}
\alias{coerce,array,anlz-method}
\alias{coerce,array,nifti-method}
\alias{coerce,list,anlz-method}
\alias{coerce,list,nifti-method}
\alias{coerce-methods}
\alias{coerce<-,anlz,nifti-method}
\alias{coerce<-,array,anlz-method}
\alias{coerce<-,array,nifti-method}
\alias{coerce<-,list,anlz-method}
\alias{coerce<-,list,nifti-method}
\title{Force an Object to Belong to the ANALYZE or NIfTI Class}
\arguments{
\item{object}{is an object of class \code{array} or inherits from
\code{array}.}

\item{Class}{is the name of the class to which \sQuote{object} should be
coerced; i.e., \code{nifti}.}

\item{value}{is the values used to modify \sQuote{object} (see the
discussion below).  You should supply an object with class \code{nifti} in
order to pass NIfTI header information.}

\item{from}{is the object to be converted.}

\item{value}{is the \code{nifti} class object to use as a template for
various ANALYZE/NIfTI header information.}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}
}
\value{
An object of class \code{anlz} or \code{nifti}.
}
\description{
Methods for function \code{coerce} in Package \sQuote{methods}.
}
\section{Methods}{

\describe{
\item{from = "anlz", to = "nifti"}{An object of class \code{anlz} is coerced
into a NIfTI object.}
\item{from = "array", to = "anlz"}{An object of class \code{array} is
coerced into an ANALYZE object.}
\item{from = "array", to = "nifti"}{An object of class \code{array} is
coerced into a NIfTI object.}
\item{from = "list", to = "anlz"}{All objects of class \code{array} in the
list are coerced into ANALYZE objects.  All other objects are left alone.
The original list structure is retained.}
\item{from = "list", to = "nifti"}{All objects of class \code{array} in the
list are coerced into NIfTI objects.  All other objects are left alone.  The
original list structure is retained.}
}
}
\author{
Andrew Thornton \email{zeripath@users.sourceforge.net},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\seealso{
\code{\link{as}}
}
\keyword{methods}

