% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qoffset_z.R, R/zzz_niftiImage.R
\docType{methods}
\name{qoffset_z-methods}
\alias{qoffset_z-methods}
\alias{qoffset_z-methods,}
\alias{qoffset_z}
\alias{qoffset_z,nifti-method}
\alias{qoffset_z<-}
\alias{qoffset_z<-,nifti-method}
\alias{qoffset.z}
\alias{qoffset.z,nifti-method}
\alias{qoffset.z<-}
\alias{qoffset.z<-,nifti-method}
\alias{qoffset_z,niftiImage-method}
\alias{qoffset_z<-,niftiImage-method}
\title{Extract Image Attribute \code{qoffset_z}}
\usage{
qoffset_z(object)

\S4method{qoffset_z}{nifti}(object)

qoffset_z(object) <- value

\S4method{qoffset_z}{nifti}(object) <- value

qoffset.z(object)

\S4method{qoffset.z}{nifti}(object)

qoffset.z(object) <- value

\S4method{qoffset.z}{nifti}(object) <- value

\S4method{qoffset_z}{niftiImage}(object)

\S4method{qoffset_z}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{qoffset_z} field.}
}
\description{
Methods that act on the \code{qoffset_z} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
qoffset_z(img)
qoffset_z(img) = 10
stopifnot(qoffset_z(img) == 10)
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
