% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img_length.R
\name{img_length}
\alias{img_length}
\title{Gets Image Length in Each Dimension}
\usage{
img_length(img, units = c("mm", "cm"))
}
\arguments{
\item{img}{Image object, any method with \code{voxdim} and \code{dim_}}

\item{units}{output unit, either cubic mm or cubic cm.}
}
\value{
Scalar numeric, one number, in mm or cm.
}
\description{
Multiplies the number of slices by the voxel resolution for
each direction.
}
\examples{
nim <- nifti(array(rnorm(10^3), dim = c(5, 2, 100)),
pixdim = c(1, 0.5, 0.2, 1))
img_length(nim) 
}
