% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/es.R
\name{es}
\alias{es}
\title{Expression substitution}
\usage{
es(text, round = NULL, signif = NULL, envir = parent.frame())
}
\arguments{
\item{text}{A vector of strings to substitute into.}

\item{round}{\code{NULL} or a single integer, giving the number of decimal
digits for rounding numeric expressions. This argument takes priority over
\code{signif}.}

\item{signif}{\code{NULL} or a single integer, giving the number of
significant decimal digits to use for numeric expressions. The
\code{round} argument takes priority over this one, and will be used if
not \code{NULL}.}

\item{envir}{The environment to evaluate expressions in.}
}
\value{
The final strings, with expression values substituted into them.
}
\description{
Evaluate R expressions and substitute their values into one or more strings.
}
\details{
Each part of the string surrounded by \code{"#{}"} is extracted, evaluated
as R code in the specified environment, and then its value is substituted
back into the string. The literal string \code{"#{}"} can be obtained by
escaping the hash character, viz. \code{"\\#{}"}. The block may contain
multiple R expressions, separated by semicolons, but may not contain
additional braces.
}
\examples{
es("pi is #{pi}")
es("pi is \\\\#{pi}")
es("The square-root of pi is approximately #{sqrt(pi)}", signif=4)
es("1/(1+x) for x=3 is #{x <- 3; 1/(1+x)}")
}
\seealso{
\code{\link{ore.subst}}
}

