% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-conference.r
\name{conference}
\alias{conference}
\alias{recover_conference}
\alias{recover_conference.default}
\alias{get_conference}
\alias{revert_conference}
\alias{confer_inertia}
\title{Confer inertia to factors of a 'tbl_ord' object}
\usage{
recover_conference(x)

\method{recover_conference}{default}(x)

get_conference(x)

revert_conference(x)

confer_inertia(x, p)
}
\arguments{
\item{x}{A \link{tbl_ord}.}

\item{p}{Numeric vector of length 1 or 2. If length 1, the proportion of the
inertia assigned to the cases, with the remainder \code{1 - p} assigned to the
variables. If length 2, the proportions of the inertia assigned to the
cases and to the variables, respectively.}
}
\value{
\code{recover_conference()} returns the (statically implemented)
distribution of inertia between the rows and the columns as stored in the
model. \code{confer_inertia()} returns a tbl_ord with a specified distribution
of inertia but the wrapped model unchanged. \code{get_conference()} returns the
distribution currently conferred.
}
\description{
Re-distribute inertia between rows and columns in an
ordination.
}
\details{
The \emph{inertia} of a singular value decomposition \eqn{X=UDV'} consists in the
squares of the singular values (the diagonal elements of \eqn{D}), and
represents the variance, likened to the physical inertia, in the directions
of the orthogonal singular vectors (the columns of \eqn{U} or of \eqn{V}).
Biplots superimpose the projections of the rows and the columns of \eqn{X}
onto these coordinate vectors, scaled by some proportion of the total
inertia: \eqn{UD^p} and \eqn{VD^q}. A biplot is \emph{balanced} if \eqn{p+q=1}.
Read Orlov (2013) for more on conferring inertia in PCA.

\code{recover_conference()}, like the other recoverers, is an \link[base:UseMethod]{S3 method} that is exported for convenience but not intended to
be used directly.

\emph{Note: In case the \code{"inertia"} attribute is a rectangular matrix, one may
only be able to confer it entirely to the cases (\code{p = 1}) or entirely to the
variables (\code{p = 0}).}
}
\examples{
# illustrative ordination: correspendence analysis of hair & eye data
haireye_ca <- ordinate(
  as.data.frame(rowSums(HairEyeColor, dims = 2L)),
  cols = everything(), model = MASS::corresp
)
print(haireye_ca)

# check distribution of inertia
get_conference(haireye_ca)
# confer inertia to rows, then to columns
confer_inertia(haireye_ca, "rows")
confer_inertia(haireye_ca, "columns")
# confer inertia symmetrically
(haireye_ca <- confer_inertia(haireye_ca, "symmetric"))
# check redistributed inertia
get_conference(haireye_ca)
# restore default distribution of inertia
revert_conference(haireye_ca)
}
\references{
Orlov K (2013) \emph{Answer to} "Algebra of LDA. Fisher discrimination power of a
variable and Linear Discriminant Analysis". CrossValidated, accessed
2019-07-26. \url{https://stats.stackexchange.com/a/83114/68743}
}
\seealso{
Other generic recoverers: 
\code{\link{augmentation}},
\code{\link{recoverers}},
\code{\link{supplementation}}
}
\concept{generic recoverers}
