% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ordinalNet.R
\name{print.ordinalNetFit}
\alias{print.ordinalNetFit}
\title{Print method for an "ordinalNetFit" object.}
\usage{
\method{print}{ordinalNetFit}(x, ...)
}
\arguments{
\item{x}{An "ordinalNetFit" S3 object.}

\item{...}{Not used. Additional print arguments.}
}
\value{
Silently returns the model fit summary.
}
\description{
Provides a model fit summary in matrix form. For each \code{lambda} value in
the solution path, the following information is included: degrees of freedom
(number of nonzero parameters), AIC, BIC, and percent deviance explained.
}
\examples{
set.seed(10)
x <- matrix(rnorm(50*5), ncol=5)
beta <- c(1, 0, 0, 0, 0)
intercepts <- c(-1, 1)
xb <- x \%*\% beta
eta <- cbind(xb+intercepts[1], xb+intercepts[2])
probMatCumul <- 1 / (1 + exp(-eta))
probMat <- cbind(probMatCumul, 1) - cbind(0, probMatCumul)
y <- apply(probMat, 1, function(p) sample(1:3, size=1, prob=p))
y <- as.factor(y)
fit <- ordinalNet(x, y)
print(fit)
}

