% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{logLik.ocm}
\alias{logLik.ocm}
\title{Extract Log-likelihood for a Continuous Ordinal  Model}
\usage{
\method{logLik}{ocm}(object, ...)
}
\arguments{
\item{object}{an \code{ocm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
The log-likelihood of an \code{ocm} object. This is a number with attributes
\item{df}{estimated degrees of freedom for the fitted model \code{object}. When the model maximizes the penalized likelihood, i.e. smoothing is involved in the g function or the formula contains random effects, the effective degrees of freedom are returned.}
\item{nobs}{number of observations used in the fitted model \code{object}}
\item{class}{class of the returned object: \code{logLik.ocm}}
}
\description{
Extracts the log-likelihood for a fitted \code{ocm} object
}
\examples{
\dontrun{
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
logLik(fit.overall)
}
}
\seealso{
\code{\link{ocm}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
