% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordDisp-class.R, R/ordDisp.R
\docType{class}
\name{ordDisp-class}
\alias{ordDisp}
\alias{ordDisp-class}
\title{Separating Location and Dispersion in Ordinal Regression Models}
\usage{
ordDisp(formula, data, family = c("cumulative", "acat"), scaling = TRUE,
  middle = TRUE, m = NULL, ...)
}
\arguments{
\item{formula}{Object of class \code{\link{formula}}: a symbolic description of the model to be fitted. See details.}

\item{data}{Data.frame of class \code{\link{data.frame}} containing the variables of the model.}

\item{family}{Type of link function that is used to link the mean responses to the linear predictors of the model; 
ordDisp currently allows only one out of \code{"cumulative"} and \code{"acat"}. See details.}

\item{scaling}{If true, the thresholds of the location-shift model are shifting by using scale values for the widening of 
the intervals between two thresholds.}

\item{middle}{If true, the model expects a symmetric response of the form 'strongly disagree','moderatly disagree',...,
'moderatly agree','strongly agree'.}

\item{m}{Middle category of the (non-symmetric) response, chosen for the model. Only relevant, if \code{middle=FALSE}.}

\item{...}{Further arguments passed to or from other methods}
}
\value{
Object of class \code{ordDisp} which inherits from \code{\link{vglm}}. The object comprises all the slots of an 
\code{"vglm"}-object and in addition the following components: 

\item{outercall}{The matched call of \code{ordDisp}.}
\item{X}{Design matrix of x-variables.}
\item{Z}{Design matrix of z-variables.}

All the methods implemented for objects of class \code{vglm}, like \code{print}, \code{summary}, \code{predict} 
and \code{plot} can be applied.
}
\description{
A function to estimate the location-shift model or rating-scale model accounting for response styles (RSRS) 
for the regression analysis of ordinal responses. The model allows to account for differing variability in 
subgroups of the population. The model explicitely links varying disperion (or response behaviour) to explanatory 
variables. The basic models are described in Tutz and Berger (2016a) and Tutz and Berger (2016b).
}
\details{
The \link{formula} has to have the form \code{response ~ x-variables|z-variables}, where \code{response} is the name of 
the ordinal response variable, \code{x-variables} are the terms that specify the location (or content-related) effects 
of the model and \code{z-variables} are the terms that specify the dispersion (or response-style) effects.

If all the variables are entered in both parts of the model, the right hand side of the formula can, for example, 
have the form \code{x1+...+xp|x1+...+xp}. If the second part is omitted, a simple model without dispersion 
(or response-style) effects is fitted.

Function \code{ordDisp} internally calls \code{\link{vglm}} from package \code{\link{VGAM}}. Argument \code{family} is passed to \code{vglm}. 
Currently two link functions are implemented

\itemize{
\item \code{"cumulative"} to estimate a cumulative model of the form 
\deqn{P(y\leq r)/P(y>r)=eta_r}
\item \code{"acat"} to estimate a adjacent-categories model of the form 
\deqn{P(y=r+1)/P(y=r)=eta_r}
}
}
\examples{
data(reti)

mod <- ordDisp(RET~SM+DIAB+GH+BP|SM+DIAB,data=reti,family="cumulative")
summary(mod)

}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Tutz, Gerhard and Berger, Moritz (2016a): Response Styles in Rating Scales - Simultaneous Modelling of 
Content-Related Effects and the Tendency to Middle or Extreme Categories, 
Journal of Educational and Behavioral Statistics 41(3), 239-268.

Tutz, Gerhard and Berger, Moritz (2016b): Seperating Location and Dispersion in Ordinal Regression Models, 
LMU Muenchen, Institut fuer Statistik, Technical Report 190
}
\seealso{
\code{\link[VGAM]{summaryvglm}}, \code{\link[VGAM]{predictvglm}}, \code{\link[ordDisp]{plotordDisp}}
}

