% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envvars.R
\name{envvar_fns}
\alias{envvar_fns}
\alias{envvar_is}
\alias{envvar_is.NULL}
\alias{envvar_is.character}
\alias{envvar_is.numeric}
\alias{envvar_is.logical}
\alias{envvar_eval}
\alias{envvar_eval_or_raw}
\alias{envvar_is_one_of}
\alias{envvar_choice_of}
\alias{envvar_is_true}
\alias{envvar_is_false}
\alias{envvar_is_set}
\alias{envvar_str_split}
\title{Generator functions for environment variable processors}
\usage{
envvar_is(value, ...)

\method{envvar_is}{`NULL`}(value, case_sensitive = FALSE, ...)

\method{envvar_is}{character}(value, case_sensitive = FALSE, ...)

\method{envvar_is}{numeric}(value, ...)

\method{envvar_is}{logical}(value, case_sensitive = FALSE, ...)

envvar_eval(...)

envvar_eval_or_raw(...)

envvar_is_one_of(values, ...)

envvar_choice_of(values, default = NULL, ...)

envvar_is_true(...)

envvar_is_false(...)

envvar_is_set(...)

envvar_str_split(delim = ";", ...)
}
\arguments{
\item{value}{A value to test against}

\item{...}{Other arguments unused}

\item{case_sensitive}{A logical value indicating whether string comparisons
should be case-sensitive.}

\item{values}{A list or vector of values to match}

\item{default}{A default value used when a value cannot be coerced from the
environment variable value}

\item{delim}{A character value to use as a delimiter to use when splitting
the environment variable value}
}
\value{
A function to be used for processing an environment variable value
}
\description{
These functions return environment variable processor functions. Arguments to
them are used to specify behaviors.
}
\section{Functions}{
\itemize{
\item \code{envvar_is()}: Test for equality with handlers for most atomic R types, performing sensible
interpretation of environment variable values.

\item \code{envvar_is(`NULL`)}: environment variable has value \code{"null"}

\item \code{envvar_is(character)}: environment variable is equal to string \code{value}

\item \code{envvar_is(numeric)}: environment variable is equal to string representation of numeric \code{value}

\item \code{envvar_is(logical)}: environment variable is equal to string representation of logical \code{value}

\item \code{envvar_eval()}: Parse the environment variable value as R code and and evaluate it to
produce a return value, emitting an error if the expression fails to parse
or evaluate. This option is a sensible default for most R-specific
environment variables, but may fail for string literals, and meaningful
values that don't conform to R's syntax like \verb{"true}" (see
\code{\link[=envvar_is_true]{envvar_is_true()}}), \code{"false"} (see \code{\link[=envvar_is_false]{envvar_is_false()}}) or \code{"null"}.

\item \code{envvar_eval_or_raw()}: Parse the environment variable value as R code and and evaluate it to
produce a return value, or falling back to the raw value as a string if an
error occurs.

\item \code{envvar_is_one_of()}: For meaningful string comparisons, check whether the environment variable is
equal to some meaningful string. Optionally with case-sensitivity.

\item \code{envvar_choice_of()}: Check whether environment variable can be coerced to match one of \code{values},
returning the value if it matches or \code{default} otherwise.

\item \code{envvar_is_true()}: Test whether the environment variable is "truthy", that is whether it is
case-insensitive \code{"true"} or \code{1}

\item \code{envvar_is_false()}: Test whether the environment variable is "falsy", that is whether it is
case-insensitive \code{"false"} or \code{0}

\item \code{envvar_is_set()}: Test whether the environment variable is set. This is somewhat
operating-system dependent, as not all operating systems can distinguish
between an empty string as a value and an unset environment variable. For
details see \code{\link[=Sys.getenv]{Sys.getenv()}}'s Details about its \code{unset} parameter.

\item \code{envvar_str_split()}: Interpret the environment variable as a delimited list of strings, such as
\code{PATH} variables.

}}
\keyword{envvar_parsers}
