% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_strata.R
\name{split_strata}
\alias{split_strata}
\title{Split Strata}
\usage{
split_strata(
  data,
  strata,
  split = NULL,
  split_var,
  type = "global quantile",
  split_at = 0.5,
  trunc = NULL
)
}
\arguments{
\item{data}{a dataframe or matrix with one row for each
sampling unit, one column specifying each unit's current
stratum, one column containing the continuous or categorical
values that will define the split, and any other relevant
columns.}

\item{strata}{a character string specifying the name of the
column that defines each unit's current strata.}

\item{split}{the name of the stratum or strata to be split,
exactly as they appear in \code{strata}. Defaults to NULL,
which indicates that all strata in \code{strata} will be split.}

\item{split_var}{a character string specifying the name of the
column that should be used to define the strata splits.}

\item{type}{a character string specifying how the function
should interpret the \code{split_at} argument. Must be one of:
\itemize{
\item \code{"global quantile"}, the default, splits the strata
at the quantiles specified in \code{split_at} defined along
the entire, unfiltered \code{split_var} column.
\item \code{"local quantile"} splits the strata at the
quantiles specified in \code{split_at} defined along the
filtered \code{split_var} column which only includes units in
the stratum being split.
\item \code{"value"} splits the strata at the values specified
in \code{split_at} along \code{split_var} column.
\item \code{"categorical"} splits the strata into two new
strata, one that contains each unit where \code{split_var}
matches an input of \code{split_at}, and a second that contains
every other unit.
}}

\item{split_at}{the percentile, value, or name(s) which
\code{split_var} should be split at. The interpretation of
this input depends on \code{type}. For \code{"quantile"} types,
input must be between \code{0} and \code{1}. Defaults to
\code{0.5} (median). For \code{"categorical"} type, the
input should be a vector of values or names in \code{split_var}
that define the new stratum.}

\item{trunc}{A numeric or character value specifying how the
name of the \code{split_var} should be truncated when naming
the new strata. If numeric, the new strata name will only
include the first 'n' characters of the \code{split_var} name.
If character, the specified string will be used to name the new
strata instead of the \code{split_var} name. Defaults to
\code{NULL}, which creates the new strata name using the entire
name of the \code{split_var} column.}
}
\value{
Returns the input dataframe with a new column named
'new_strata' that holds the name of the stratum that each
sample belongs to after the split. The column containing the
previous strata names is retained and given the name "old_strata".
}
\description{
Splits pre-defined sampling strata based on values of a
continuous or categorical variable.
}
\details{
For splits on continuous variables, the new strata are defined
on left-open intervals. The only exception is the first interval,
which must include the overall minimum value. The names of the newly
created strata for a split generated
from a continuous value are the \code{split_var} column name with
the range of values defining that stratum appended to the
old strata name. For a categorical split, the new strata names
are the \code{split_var} column name appended to the
1/0 logical flag specifying whether the unit is in \code{split at},
all appended to the old strata name.
If the \code{split_var} column name is long,
the user can specify a value for \code{trunc} to prevent the new
strata names from being inconveniently long.
}
\examples{
x <- split_strata(iris, "Sepal.Length",
  strata = c("Species"),
  split = "setosa", split_var = "Sepal.Width",
  split_at = c(0.5), type = "global quantile"
)

# You can split at more than one quantile in one call.
# The above call splits the "setosa" stratum into three of equal size
x <- split_strata(iris, "Sepal.Length",
  strata = c("Species"),
  split = "setosa", split_var = "Sepal.Width", split_at = c(0.33, 0.66),
  type = "local quantile"
)

# Manually select split values with type = "value"
x <- split_strata(iris, "Sepal.Length",
  strata = "Species",
  split = "setosa", split_var = "Sepal.Width",
  split_at = c(3.1, 3.8), type = "value"
)

# Perform a categorical split.
iris$strata <- rep(c(rep(1, times = 25), rep(0, times = 25)), times = 3)
x <- split_strata(iris, "Sepal.Length",
  strata = "strata",
  split = NULL, split_var = "Species",
  split_at = c("virginica", "versicolor"), type = "categorical"
)
# Splits each initial strata 1 and 2 into one stratum with "virginia"
# and "versicolor" species and one stratum with all of the other species
# not specified in the split_at argument.
}
