% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{update_weightsI}
\alias{update_weightsI}
\title{Update weight I-Optimality}
\usage{
update_weightsI(design, sens, crit, delta)
}
\arguments{
\item{design}{Design to optimize the weights from. It's a dataframe with two columns:
\itemize{
\item \code{Point} contains the support points of the design.
\item \code{Weight} contains the corresponding weights of the \code{Point}s.
}}

\item{sens}{Sensibility function for the design and model.}

\item{crit}{Value of the criterion function for I-Optimality.}

\item{delta}{A parameter of the algorithm that can be tuned. Must be \eqn{0< delta < 1}.}
}
\value{
returns the new weights of the design after one iteration.
}
\description{
Implementation of the weight update formula for I-Optimality used to optimize the weights of a design,
which is to be applied iteratively until no sizable changes happen. A-Optimality if instead of the
integral matrix the identity function is used.
}
