% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOverallPower.R
\name{getOverallPower}
\alias{getOverallPower}
\title{Calculate the overall power}
\usage{
getOverallPower(design, alternative)
}
\arguments{
\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}

\item{alternative}{Assumed relative effect size.}
}
\value{
The overall power of the design at the provided effect size.
}
\description{
Calculate the overall power and other operating characteristics of a design.
}
\details{
This function is used to evaluate the overall performance of a design.
The probabilities for first-stage futility, first-stage efficacy and overall efficacy (i.e., overall power) are saved in an object of class \code{PowerResultsOptimalConditionalError}.
}
\examples{
# Get a design
design <- getDesignOptimalConditionalErrorFunction(
alpha = 0.025, alpha1 = 0.001, alpha0 = 0.5, conditionalPower = 0.9,
delta1 = 0.25, likelihoodRatioDistribution = "fixed", deltaLR = 0.25,
firstStageInformation = 80, useInterimEstimate = FALSE,
)

getOverallPower(design, alternative = 0.25)

}
\seealso{
\code{\link[=getDesignOptimalConditionalErrorFunction]{getDesignOptimalConditionalErrorFunction()}}, \code{\link[=getSimulationResults]{getSimulationResults()}}
}
