\name{repRankAggreg}
\alias{repRankAggreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Repeat Rank Aggregation}
\description{
  \code{repRankAggreg} repeats rank aggregation of ordered validation measure lists 
  obtained from an \cr object of class \code{"\linkS4class{optCluster}"}. The 
  function returns an object of class \code{"\linkS4class{optCluster}"}.
}
\usage{
  repRankAggreg(optObj, rankMethod = "same", distance = "same", 
  importance = NULL, rankVerbose = FALSE, ... ) 
}


\arguments{
  \item{optObj}{An object of class \code{"\linkS4class{optCluster}"}.}
  \item{rankMethod}{A character string
  	providing the method to be used for rank aggregation. As default, the "same" 
  	method as the input \code{"\linkS4class{optCluster}"} object is used. The 
  	cross-entropy Monte Carlo algorithm ("CE") or Genetic algorithm ("GA") can also be 
  	directly specified.  Selection of only one method is allowed.}  
  \item{distance}{A character string providing the type of distance to be used for measuring the similarity between ordered lists  
  	in rank aggregation.  As default, the "same" distance as the input \code{"\linkS4class{optCluster}"} object is used. 
  	The weighted Spearman footrule distance ("Spearman") or the weighted Kendall's tau distance \cr("Kendall") 
  	can also be directly specified.  Selection of only one distance is allowed.}
  \item{importance}{Vector of weights indicating the importance of each validation measure list.  
    Default of NULL represents equal weights to each validation measure.  See \bold{Weighted Rank Aggregation} 
    in the details section for more information.}
  \item{rankVerbose}{If TRUE, current rank aggregation results are displayed at each iteration.}
  \item{\dots}{Additional arguments that can be passed to the internal function \code{RankAggreg}:
    \itemize{
    \item{\code{k} - Size of top-k list in aggregation.}
    \item{\code{convIN} - Stopping criteria for CE and GA algorithms.  The algorithm converges once the "best" solution does not
    change after convIN iterations.  Default: 7 for CE and 30 for GA.}
    \item{\code{N} - Number of samples generated by MCMC in the CE algorithm.  Default = 10*k^2}
    \item{\code{rho} - For CE algorithm, (rho*N) is the qunatile of candidate list sorted by function values.}
    \item{\code{weight} - For CE algorithm, the learning factor used in the probability update feature.  Default = 0.25}
    \item{\code{popSize} - For GA algorithm population size in each generation. Default = 100}
    \item{\code{CP} - For GA algorithm, the cross-over probability.  Default = 0.4}
    \item{\code{MP} - For GA algorithm, the mutation probability.  Default = 0.01}
    }
  }
}

\details{
	This function tests the consistency of the rank aggregation results by repeating rank aggregation with the same 
	rank aggregation method, distance measure, clustering algorithm lists, and validation score lists used to create
	the input object of class \code{"\linkS4class{optCluster}"}.  A different rank aggregation algorithm or 
	type of distance measure can also be evaluated using this function, but doing so may affect the final results. \cr
	
	\bold{Weighted Rank Aggregation:}{ A list of weights for each validation measure list
	can be included using the \code{importance} argument.  The default value of equal weights (NULL) is 
	represented by rep(1, length(x)), where x is the character vector of validation measure names.
	To manually change the weights, the order of the validation measures selected needs to be known.
	The order of validation measures used in \code{optCluster} is provided below:
		  
	\itemize{
	\item{When selected, stability measures will ALWAYS be listed first and in the following order: "APN", "AD", "ADM", "FOM".}
		  
	\item{When selected, internal measures will only precede biological measures.  The order of these measures is:
	"Connectivity", "Dunn", "Silhouette".}
		  
	\item{When selected, biological measures will always be listed last and in the following order: "BHI", "BSI".}
		  
	}}
	
}

\value{

  \code{repRankAggreg} returns an object of class \code{"\linkS4class{optCluster}"}.  The class description 
  is provided in the help file.

}
\references{
  
  Pihur, V., Datta, S. and Datta, S. (2007).
  Weighted rank aggregation of cluster validation measures: A Mounte Carlo cross-entropy approach.
  Bioinformatics 23(13): 1607-1615.
     
  Pihur, V., Datta, S. and Datta, S. (2009).
  RankAggreg, an R package for weighted rank aggregation.
  BMC Bioinformatics, 10:62,
  \url{http://www.biomedcentral.com/1471-2105/10/62}.
  
  Sekula, M. (2015). 
  optCluster : An R package for Determining the Optimal Clustering Algorithm and Optimal Number of Clusters.
  Electronic Theses and Dissertations. Paper 2147.
  \url{http://ir.library.louisville.edu/etd/2147}  
}

\author{Michael Sekula, Somnath Datta, Susmita Datta}


\seealso{

  For a description of the \code{RankAggreg} function, including all available arguments that can be
  passed to it, see \code{\link{RankAggreg}} in the \pkg{RankAggreg} package.  
  
  }

\examples{
	
	## These examples may take a few minutes to compute
	\donttest{	
	## Obtain Dataset	
	data(arabid)			
	
	## Normalize Data with Respect to Library Size	
	obj <- t(t(arabid)/colSums(arabid))
	
	## Analysis of Normalized Data using Internal and Stability Validation Measures
	norm1 <- optCluster(obj, 2:4, clMethods = "all")
	print(norm1)
	repCE <- repRankAggreg(norm1)
	print(repCE)
	repGA <- repRankAggreg(norm1, rankMethod = "GA")
	print(repGA)
	}
	
}

\keyword{cluster}
\keyword{optimize}
