% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve}
\alias{solve}
\alias{solve,OptimizationProblem,Solver-method}
\alias{solve,ProjectProblem,missing-method}
\title{Solve}
\arguments{
\item{a}{\code{\link{ProjectProblem-class}} or an
\code{\link{OptimizationProblem-class}} object.}

\item{b}{\code{\link{Solver-class}} object. Not used if \code{a} is an
\code{\link{ProjectProblem-class}} object.}

\item{...}{arguments passed to \code{\link{compile}}.}
}
\value{
The type of object returned from this function depends on the
  argument to \code{a}. If the argument to \code{a} is an
  \code{\link{OptimizationProblem-class}} object, then the
  solution is returned as a \code{list} containing the prioritization and
  additional information (e.g. run time, solver status). On the other hand,
  if the argument
  to \code{a} is an \code{\link{ProjectProblem-class}} object,
  then a \code{\link[tibble]{tibble}} table object will be returned. In this
  table, each row row corresponds to a different solution and each column
  describes a different property or result associated with each solution:

  \describe{

  \item{\code{"solution"}}{\code{integer} solution identifier.}

  \item{\code{"status"}}{\code{character} describing each solution.
   For example, is the solution optimal, suboptimal, or was it returned
   because the solver ran out of time?}

  \item{\code{"obj"}}{\code{numeric} objective value for each solution.
    This is calculated using the objective function defined for the
    argument to \code{x}.}

  \item{\code{"cost"}}{\code{numeric} total cost associated with each
    solution.}

  \item{\code{x$action_names()}}{\code{numeric} column for each action
    indicating if they were funded in each solution or not.}

  \item{\code{x$project_names()}}{\code{numeric} column for each
    project indicating if it was completely funded (with a value of 1)
    or not (with a value of 0).}

  \item{\code{x$feature_names()}}{\code{numeric} column for each
    feature indicating the probability that it will persist into
    the future given each solution.}

  }
}
\description{
Solve a conservation planning \code{\link{problem}}.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# print project data
print(sim_projects)

# print action data
print(sim_features)

# print feature data
print(sim_actions)

# build problem
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 400) \%>\%
     add_feature_weights("weight") \%>\%
     add_binary_decisions()

# print problem
print(p)

\donttest{
# solve problem
s <- solve(p)

# print output
print(s)

# print the solver status
print(s$obj)

# print the objective value
print(s$obj)

# print the solution cost
print(s$cost)

# print which actions are funded in the solution
s[, sim_actions$name, drop = FALSE]

# print the expected probability of persistence for each feature
# if the solution were implemented
s[, sim_features$name, drop = FALSE]
}
}
\seealso{
\code{\link{problem}}, \code{\link{solution_statistics}},
  \code{\link{solvers}}.
}
