% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_projects.R
\name{number_of_projects}
\alias{number_of_projects}
\alias{number_of_projects,ProjectProblem-method}
\alias{number_of_projects,OptimizationProblem-method}
\title{Number of projects}
\usage{
number_of_projects(x)

\S4method{number_of_projects}{ProjectProblem}(x)

\S4method{number_of_projects}{OptimizationProblem}(x)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} or
\code{\link{OptimizationProblem-class}} object.}
}
\value{
\code{integer} number of projects.
}
\description{
Extract the number of projects in an object.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with default solver
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_default_solver()

# print problem
print(p)

# print number of projects
number_of_projects(p)
}
