% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_drawing}
\alias{wb_add_drawing}
\title{add drawings to workbook}
\usage{
wb_add_drawing(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  xml,
  col_offset = 0,
  row_offset = 0,
  ...
)
}
\arguments{
\item{wb}{a \code{wbWorkbook}}

\item{sheet}{a sheet in the workbook}

\item{dims}{the dimension where the drawing is added. Can be \code{NULL}}

\item{xml}{the drawing xml as character or file}

\item{col_offset, row_offset}{offsets for column and row}

\item{...}{additional arguments}
}
\description{
add drawings to workbook
}
\examples{
if (requireNamespace("rvg") && interactive()) {

## rvg example
require(rvg)
tmp <- tempfile(fileext = ".xml")
dml_xlsx(file =  tmp)
plot(1,1)
dev.off()

wb <- wb_workbook()$
  add_worksheet()$
  add_drawing(xml = tmp)$
  add_drawing(xml = tmp, dims = NULL)
}
}
\seealso{
\code{\link[=wb_add_chart_xml]{wb_add_chart_xml()}} \code{\link[=wb_add_image]{wb_add_image()}} \code{\link[=wb_add_mschart]{wb_add_mschart()}} \code{\link[=wb_add_plot]{wb_add_plot()}}
}
