% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{get_date_origin}
\alias{get_date_origin}
\title{Get the date origin an xlsx file is using}
\usage{
get_date_origin(xlsxFile, origin = FALSE)
}
\arguments{
\item{xlsxFile}{An xlsx or xlsm file or a wbWorkbook object.}

\item{origin}{return the origin instead of the character string.}
}
\value{
One of "1900-01-01" or "1904-01-01".
}
\description{
Return the date origin used internally by an xlsx or xlsm file
}
\details{
Excel stores dates as the number of days from either 1904-01-01 or 1900-01-01. This function
checks the date origin being used in an Excel file and returns is so it can be used in \code{\link[=convert_date]{convert_date()}}
}
\examples{

## create a file with some dates
temp <- temp_xlsx()
write_xlsx(as.Date("2015-01-10") - (0:4), file = temp)
m <- read_xlsx(temp)

## convert to dates
do <- get_date_origin(system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2"))
convert_date(m[[1]], do)

get_date_origin(wb_workbook())
get_date_origin(wb_workbook(), origin = TRUE)
}
\seealso{
\code{\link[=convert_date]{convert_date()}}
}
