% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{xml_attr_mod}
\alias{xml_attr_mod}
\title{adds or updates attribute(s) in existing xml node}
\usage{
xml_attr_mod(xml_content, xml_attributes, escapes = FALSE, declaration = FALSE)
}
\arguments{
\item{xml_content}{some valid xml_node}

\item{xml_attributes}{R vector of named attributes}

\item{escapes}{bool if escapes should be used}

\item{declaration}{bool if declaration should be imported}
}
\description{
Needs xml node and named character vector as input. Modifies
the arguments of each first child found in the xml node and adds or updates
the attribute vector.
}
\details{
If a named attribute in \code{xml_attributes} is "" remove the attribute
from the node.
If \code{xml_attributes} contains a named entry found in the xml node, it is
updated else it is added as attribute.
}
\examples{
  # add single node
    xml_node <- "<a foo=\"bar\">openxlsx2</a><b />"
    xml_attr <- c(qux = "quux")
    # "<a foo=\"bar\" qux=\"quux\">openxlsx2</a><b qux=\"quux\"/>"
    xml_attr_mod(xml_node, xml_attr)

  # update node and add node
    xml_node <- "<a foo=\"bar\">openxlsx2</a><b />"
    xml_attr <- c(foo = "baz", qux = "quux")
    # "<a foo=\"baz\" qux=\"quux\">openxlsx2</a><b foo=\"baz\" qux=\"quux\"/>"
    xml_attr_mod(xml_node, xml_attr)

  # remove node and add node
    xml_node <- "<a foo=\"bar\">openxlsx2</a><b />"
    xml_attr <- c(foo = "", qux = "quux")
    # "<a qux=\"quux\">openxlsx2</a><b qux=\"quux\"/>"
    xml_attr_mod(xml_node, xml_attr)
}
