




context("Writing Sheet Data XML")


test_that("Writing sheetData rows XML - iris", {
  
  temp_file <- tempfile(fileext = ".xlsx")
  openxlsx::write.xlsx(iris, temp_file)
  
  unzip(temp_file, exdir = tempdir())
  x <- readLines(file.path(tempdir(), "xl", "worksheets", "sheet1.xml"), warn = FALSE, encoding = "UTF-8")
  rows <- unlist(regmatches(x = x, gregexpr("<row.*?</row>", x)))

  expected_rows <- c("<row r=\"1\"><c r=\"A1\" t=\"s\"><v>0</v></c><c r=\"B1\" t=\"s\"><v>1</v></c><c r=\"C1\" t=\"s\"><v>2</v></c><c r=\"D1\" t=\"s\"><v>3</v></c><c r=\"E1\" t=\"s\"><v>4</v></c></row>", 
                     "<row r=\"2\"><c r=\"A2\" t=\"n\"><v>5.1</v></c><c r=\"B2\" t=\"n\"><v>3.5</v></c><c r=\"C2\" t=\"n\"><v>1.4</v></c><c r=\"D2\" t=\"n\"><v>0.2</v></c><c r=\"E2\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"3\"><c r=\"A3\" t=\"n\"><v>4.9</v></c><c r=\"B3\" t=\"n\"><v>3</v></c><c r=\"C3\" t=\"n\"><v>1.4</v></c><c r=\"D3\" t=\"n\"><v>0.2</v></c><c r=\"E3\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"4\"><c r=\"A4\" t=\"n\"><v>4.7</v></c><c r=\"B4\" t=\"n\"><v>3.2</v></c><c r=\"C4\" t=\"n\"><v>1.3</v></c><c r=\"D4\" t=\"n\"><v>0.2</v></c><c r=\"E4\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"5\"><c r=\"A5\" t=\"n\"><v>4.6</v></c><c r=\"B5\" t=\"n\"><v>3.1</v></c><c r=\"C5\" t=\"n\"><v>1.5</v></c><c r=\"D5\" t=\"n\"><v>0.2</v></c><c r=\"E5\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"6\"><c r=\"A6\" t=\"n\"><v>5</v></c><c r=\"B6\" t=\"n\"><v>3.6</v></c><c r=\"C6\" t=\"n\"><v>1.4</v></c><c r=\"D6\" t=\"n\"><v>0.2</v></c><c r=\"E6\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"7\"><c r=\"A7\" t=\"n\"><v>5.4</v></c><c r=\"B7\" t=\"n\"><v>3.9</v></c><c r=\"C7\" t=\"n\"><v>1.7</v></c><c r=\"D7\" t=\"n\"><v>0.4</v></c><c r=\"E7\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"8\"><c r=\"A8\" t=\"n\"><v>4.6</v></c><c r=\"B8\" t=\"n\"><v>3.4</v></c><c r=\"C8\" t=\"n\"><v>1.4</v></c><c r=\"D8\" t=\"n\"><v>0.3</v></c><c r=\"E8\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"9\"><c r=\"A9\" t=\"n\"><v>5</v></c><c r=\"B9\" t=\"n\"><v>3.4</v></c><c r=\"C9\" t=\"n\"><v>1.5</v></c><c r=\"D9\" t=\"n\"><v>0.2</v></c><c r=\"E9\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"10\"><c r=\"A10\" t=\"n\"><v>4.4</v></c><c r=\"B10\" t=\"n\"><v>2.9</v></c><c r=\"C10\" t=\"n\"><v>1.4</v></c><c r=\"D10\" t=\"n\"><v>0.2</v></c><c r=\"E10\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"11\"><c r=\"A11\" t=\"n\"><v>4.9</v></c><c r=\"B11\" t=\"n\"><v>3.1</v></c><c r=\"C11\" t=\"n\"><v>1.5</v></c><c r=\"D11\" t=\"n\"><v>0.1</v></c><c r=\"E11\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"12\"><c r=\"A12\" t=\"n\"><v>5.4</v></c><c r=\"B12\" t=\"n\"><v>3.7</v></c><c r=\"C12\" t=\"n\"><v>1.5</v></c><c r=\"D12\" t=\"n\"><v>0.2</v></c><c r=\"E12\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"13\"><c r=\"A13\" t=\"n\"><v>4.8</v></c><c r=\"B13\" t=\"n\"><v>3.4</v></c><c r=\"C13\" t=\"n\"><v>1.6</v></c><c r=\"D13\" t=\"n\"><v>0.2</v></c><c r=\"E13\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"14\"><c r=\"A14\" t=\"n\"><v>4.8</v></c><c r=\"B14\" t=\"n\"><v>3</v></c><c r=\"C14\" t=\"n\"><v>1.4</v></c><c r=\"D14\" t=\"n\"><v>0.1</v></c><c r=\"E14\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"15\"><c r=\"A15\" t=\"n\"><v>4.3</v></c><c r=\"B15\" t=\"n\"><v>3</v></c><c r=\"C15\" t=\"n\"><v>1.1</v></c><c r=\"D15\" t=\"n\"><v>0.1</v></c><c r=\"E15\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"16\"><c r=\"A16\" t=\"n\"><v>5.8</v></c><c r=\"B16\" t=\"n\"><v>4</v></c><c r=\"C16\" t=\"n\"><v>1.2</v></c><c r=\"D16\" t=\"n\"><v>0.2</v></c><c r=\"E16\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"17\"><c r=\"A17\" t=\"n\"><v>5.7</v></c><c r=\"B17\" t=\"n\"><v>4.4</v></c><c r=\"C17\" t=\"n\"><v>1.5</v></c><c r=\"D17\" t=\"n\"><v>0.4</v></c><c r=\"E17\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"18\"><c r=\"A18\" t=\"n\"><v>5.4</v></c><c r=\"B18\" t=\"n\"><v>3.9</v></c><c r=\"C18\" t=\"n\"><v>1.3</v></c><c r=\"D18\" t=\"n\"><v>0.4</v></c><c r=\"E18\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"19\"><c r=\"A19\" t=\"n\"><v>5.1</v></c><c r=\"B19\" t=\"n\"><v>3.5</v></c><c r=\"C19\" t=\"n\"><v>1.4</v></c><c r=\"D19\" t=\"n\"><v>0.3</v></c><c r=\"E19\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"20\"><c r=\"A20\" t=\"n\"><v>5.7</v></c><c r=\"B20\" t=\"n\"><v>3.8</v></c><c r=\"C20\" t=\"n\"><v>1.7</v></c><c r=\"D20\" t=\"n\"><v>0.3</v></c><c r=\"E20\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"21\"><c r=\"A21\" t=\"n\"><v>5.1</v></c><c r=\"B21\" t=\"n\"><v>3.8</v></c><c r=\"C21\" t=\"n\"><v>1.5</v></c><c r=\"D21\" t=\"n\"><v>0.3</v></c><c r=\"E21\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"22\"><c r=\"A22\" t=\"n\"><v>5.4</v></c><c r=\"B22\" t=\"n\"><v>3.4</v></c><c r=\"C22\" t=\"n\"><v>1.7</v></c><c r=\"D22\" t=\"n\"><v>0.2</v></c><c r=\"E22\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"23\"><c r=\"A23\" t=\"n\"><v>5.1</v></c><c r=\"B23\" t=\"n\"><v>3.7</v></c><c r=\"C23\" t=\"n\"><v>1.5</v></c><c r=\"D23\" t=\"n\"><v>0.4</v></c><c r=\"E23\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"24\"><c r=\"A24\" t=\"n\"><v>4.6</v></c><c r=\"B24\" t=\"n\"><v>3.6</v></c><c r=\"C24\" t=\"n\"><v>1</v></c><c r=\"D24\" t=\"n\"><v>0.2</v></c><c r=\"E24\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"25\"><c r=\"A25\" t=\"n\"><v>5.1</v></c><c r=\"B25\" t=\"n\"><v>3.3</v></c><c r=\"C25\" t=\"n\"><v>1.7</v></c><c r=\"D25\" t=\"n\"><v>0.5</v></c><c r=\"E25\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"26\"><c r=\"A26\" t=\"n\"><v>4.8</v></c><c r=\"B26\" t=\"n\"><v>3.4</v></c><c r=\"C26\" t=\"n\"><v>1.9</v></c><c r=\"D26\" t=\"n\"><v>0.2</v></c><c r=\"E26\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"27\"><c r=\"A27\" t=\"n\"><v>5</v></c><c r=\"B27\" t=\"n\"><v>3</v></c><c r=\"C27\" t=\"n\"><v>1.6</v></c><c r=\"D27\" t=\"n\"><v>0.2</v></c><c r=\"E27\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"28\"><c r=\"A28\" t=\"n\"><v>5</v></c><c r=\"B28\" t=\"n\"><v>3.4</v></c><c r=\"C28\" t=\"n\"><v>1.6</v></c><c r=\"D28\" t=\"n\"><v>0.4</v></c><c r=\"E28\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"29\"><c r=\"A29\" t=\"n\"><v>5.2</v></c><c r=\"B29\" t=\"n\"><v>3.5</v></c><c r=\"C29\" t=\"n\"><v>1.5</v></c><c r=\"D29\" t=\"n\"><v>0.2</v></c><c r=\"E29\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"30\"><c r=\"A30\" t=\"n\"><v>5.2</v></c><c r=\"B30\" t=\"n\"><v>3.4</v></c><c r=\"C30\" t=\"n\"><v>1.4</v></c><c r=\"D30\" t=\"n\"><v>0.2</v></c><c r=\"E30\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"31\"><c r=\"A31\" t=\"n\"><v>4.7</v></c><c r=\"B31\" t=\"n\"><v>3.2</v></c><c r=\"C31\" t=\"n\"><v>1.6</v></c><c r=\"D31\" t=\"n\"><v>0.2</v></c><c r=\"E31\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"32\"><c r=\"A32\" t=\"n\"><v>4.8</v></c><c r=\"B32\" t=\"n\"><v>3.1</v></c><c r=\"C32\" t=\"n\"><v>1.6</v></c><c r=\"D32\" t=\"n\"><v>0.2</v></c><c r=\"E32\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"33\"><c r=\"A33\" t=\"n\"><v>5.4</v></c><c r=\"B33\" t=\"n\"><v>3.4</v></c><c r=\"C33\" t=\"n\"><v>1.5</v></c><c r=\"D33\" t=\"n\"><v>0.4</v></c><c r=\"E33\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"34\"><c r=\"A34\" t=\"n\"><v>5.2</v></c><c r=\"B34\" t=\"n\"><v>4.1</v></c><c r=\"C34\" t=\"n\"><v>1.5</v></c><c r=\"D34\" t=\"n\"><v>0.1</v></c><c r=\"E34\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"35\"><c r=\"A35\" t=\"n\"><v>5.5</v></c><c r=\"B35\" t=\"n\"><v>4.2</v></c><c r=\"C35\" t=\"n\"><v>1.4</v></c><c r=\"D35\" t=\"n\"><v>0.2</v></c><c r=\"E35\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"36\"><c r=\"A36\" t=\"n\"><v>4.9</v></c><c r=\"B36\" t=\"n\"><v>3.1</v></c><c r=\"C36\" t=\"n\"><v>1.5</v></c><c r=\"D36\" t=\"n\"><v>0.2</v></c><c r=\"E36\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"37\"><c r=\"A37\" t=\"n\"><v>5</v></c><c r=\"B37\" t=\"n\"><v>3.2</v></c><c r=\"C37\" t=\"n\"><v>1.2</v></c><c r=\"D37\" t=\"n\"><v>0.2</v></c><c r=\"E37\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"38\"><c r=\"A38\" t=\"n\"><v>5.5</v></c><c r=\"B38\" t=\"n\"><v>3.5</v></c><c r=\"C38\" t=\"n\"><v>1.3</v></c><c r=\"D38\" t=\"n\"><v>0.2</v></c><c r=\"E38\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"39\"><c r=\"A39\" t=\"n\"><v>4.9</v></c><c r=\"B39\" t=\"n\"><v>3.6</v></c><c r=\"C39\" t=\"n\"><v>1.4</v></c><c r=\"D39\" t=\"n\"><v>0.1</v></c><c r=\"E39\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"40\"><c r=\"A40\" t=\"n\"><v>4.4</v></c><c r=\"B40\" t=\"n\"><v>3</v></c><c r=\"C40\" t=\"n\"><v>1.3</v></c><c r=\"D40\" t=\"n\"><v>0.2</v></c><c r=\"E40\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"41\"><c r=\"A41\" t=\"n\"><v>5.1</v></c><c r=\"B41\" t=\"n\"><v>3.4</v></c><c r=\"C41\" t=\"n\"><v>1.5</v></c><c r=\"D41\" t=\"n\"><v>0.2</v></c><c r=\"E41\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"42\"><c r=\"A42\" t=\"n\"><v>5</v></c><c r=\"B42\" t=\"n\"><v>3.5</v></c><c r=\"C42\" t=\"n\"><v>1.3</v></c><c r=\"D42\" t=\"n\"><v>0.3</v></c><c r=\"E42\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"43\"><c r=\"A43\" t=\"n\"><v>4.5</v></c><c r=\"B43\" t=\"n\"><v>2.3</v></c><c r=\"C43\" t=\"n\"><v>1.3</v></c><c r=\"D43\" t=\"n\"><v>0.3</v></c><c r=\"E43\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"44\"><c r=\"A44\" t=\"n\"><v>4.4</v></c><c r=\"B44\" t=\"n\"><v>3.2</v></c><c r=\"C44\" t=\"n\"><v>1.3</v></c><c r=\"D44\" t=\"n\"><v>0.2</v></c><c r=\"E44\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"45\"><c r=\"A45\" t=\"n\"><v>5</v></c><c r=\"B45\" t=\"n\"><v>3.5</v></c><c r=\"C45\" t=\"n\"><v>1.6</v></c><c r=\"D45\" t=\"n\"><v>0.6</v></c><c r=\"E45\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"46\"><c r=\"A46\" t=\"n\"><v>5.1</v></c><c r=\"B46\" t=\"n\"><v>3.8</v></c><c r=\"C46\" t=\"n\"><v>1.9</v></c><c r=\"D46\" t=\"n\"><v>0.4</v></c><c r=\"E46\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"47\"><c r=\"A47\" t=\"n\"><v>4.8</v></c><c r=\"B47\" t=\"n\"><v>3</v></c><c r=\"C47\" t=\"n\"><v>1.4</v></c><c r=\"D47\" t=\"n\"><v>0.3</v></c><c r=\"E47\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"48\"><c r=\"A48\" t=\"n\"><v>5.1</v></c><c r=\"B48\" t=\"n\"><v>3.8</v></c><c r=\"C48\" t=\"n\"><v>1.6</v></c><c r=\"D48\" t=\"n\"><v>0.2</v></c><c r=\"E48\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"49\"><c r=\"A49\" t=\"n\"><v>4.6</v></c><c r=\"B49\" t=\"n\"><v>3.2</v></c><c r=\"C49\" t=\"n\"><v>1.4</v></c><c r=\"D49\" t=\"n\"><v>0.2</v></c><c r=\"E49\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"50\"><c r=\"A50\" t=\"n\"><v>5.3</v></c><c r=\"B50\" t=\"n\"><v>3.7</v></c><c r=\"C50\" t=\"n\"><v>1.5</v></c><c r=\"D50\" t=\"n\"><v>0.2</v></c><c r=\"E50\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"51\"><c r=\"A51\" t=\"n\"><v>5</v></c><c r=\"B51\" t=\"n\"><v>3.3</v></c><c r=\"C51\" t=\"n\"><v>1.4</v></c><c r=\"D51\" t=\"n\"><v>0.2</v></c><c r=\"E51\" t=\"s\"><v>5</v></c></row>", 
                     "<row r=\"52\"><c r=\"A52\" t=\"n\"><v>7</v></c><c r=\"B52\" t=\"n\"><v>3.2</v></c><c r=\"C52\" t=\"n\"><v>4.7</v></c><c r=\"D52\" t=\"n\"><v>1.4</v></c><c r=\"E52\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"53\"><c r=\"A53\" t=\"n\"><v>6.4</v></c><c r=\"B53\" t=\"n\"><v>3.2</v></c><c r=\"C53\" t=\"n\"><v>4.5</v></c><c r=\"D53\" t=\"n\"><v>1.5</v></c><c r=\"E53\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"54\"><c r=\"A54\" t=\"n\"><v>6.9</v></c><c r=\"B54\" t=\"n\"><v>3.1</v></c><c r=\"C54\" t=\"n\"><v>4.9</v></c><c r=\"D54\" t=\"n\"><v>1.5</v></c><c r=\"E54\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"55\"><c r=\"A55\" t=\"n\"><v>5.5</v></c><c r=\"B55\" t=\"n\"><v>2.3</v></c><c r=\"C55\" t=\"n\"><v>4</v></c><c r=\"D55\" t=\"n\"><v>1.3</v></c><c r=\"E55\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"56\"><c r=\"A56\" t=\"n\"><v>6.5</v></c><c r=\"B56\" t=\"n\"><v>2.8</v></c><c r=\"C56\" t=\"n\"><v>4.6</v></c><c r=\"D56\" t=\"n\"><v>1.5</v></c><c r=\"E56\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"57\"><c r=\"A57\" t=\"n\"><v>5.7</v></c><c r=\"B57\" t=\"n\"><v>2.8</v></c><c r=\"C57\" t=\"n\"><v>4.5</v></c><c r=\"D57\" t=\"n\"><v>1.3</v></c><c r=\"E57\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"58\"><c r=\"A58\" t=\"n\"><v>6.3</v></c><c r=\"B58\" t=\"n\"><v>3.3</v></c><c r=\"C58\" t=\"n\"><v>4.7</v></c><c r=\"D58\" t=\"n\"><v>1.6</v></c><c r=\"E58\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"59\"><c r=\"A59\" t=\"n\"><v>4.9</v></c><c r=\"B59\" t=\"n\"><v>2.4</v></c><c r=\"C59\" t=\"n\"><v>3.3</v></c><c r=\"D59\" t=\"n\"><v>1</v></c><c r=\"E59\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"60\"><c r=\"A60\" t=\"n\"><v>6.6</v></c><c r=\"B60\" t=\"n\"><v>2.9</v></c><c r=\"C60\" t=\"n\"><v>4.6</v></c><c r=\"D60\" t=\"n\"><v>1.3</v></c><c r=\"E60\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"61\"><c r=\"A61\" t=\"n\"><v>5.2</v></c><c r=\"B61\" t=\"n\"><v>2.7</v></c><c r=\"C61\" t=\"n\"><v>3.9</v></c><c r=\"D61\" t=\"n\"><v>1.4</v></c><c r=\"E61\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"62\"><c r=\"A62\" t=\"n\"><v>5</v></c><c r=\"B62\" t=\"n\"><v>2</v></c><c r=\"C62\" t=\"n\"><v>3.5</v></c><c r=\"D62\" t=\"n\"><v>1</v></c><c r=\"E62\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"63\"><c r=\"A63\" t=\"n\"><v>5.9</v></c><c r=\"B63\" t=\"n\"><v>3</v></c><c r=\"C63\" t=\"n\"><v>4.2</v></c><c r=\"D63\" t=\"n\"><v>1.5</v></c><c r=\"E63\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"64\"><c r=\"A64\" t=\"n\"><v>6</v></c><c r=\"B64\" t=\"n\"><v>2.2</v></c><c r=\"C64\" t=\"n\"><v>4</v></c><c r=\"D64\" t=\"n\"><v>1</v></c><c r=\"E64\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"65\"><c r=\"A65\" t=\"n\"><v>6.1</v></c><c r=\"B65\" t=\"n\"><v>2.9</v></c><c r=\"C65\" t=\"n\"><v>4.7</v></c><c r=\"D65\" t=\"n\"><v>1.4</v></c><c r=\"E65\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"66\"><c r=\"A66\" t=\"n\"><v>5.6</v></c><c r=\"B66\" t=\"n\"><v>2.9</v></c><c r=\"C66\" t=\"n\"><v>3.6</v></c><c r=\"D66\" t=\"n\"><v>1.3</v></c><c r=\"E66\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"67\"><c r=\"A67\" t=\"n\"><v>6.7</v></c><c r=\"B67\" t=\"n\"><v>3.1</v></c><c r=\"C67\" t=\"n\"><v>4.4</v></c><c r=\"D67\" t=\"n\"><v>1.4</v></c><c r=\"E67\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"68\"><c r=\"A68\" t=\"n\"><v>5.6</v></c><c r=\"B68\" t=\"n\"><v>3</v></c><c r=\"C68\" t=\"n\"><v>4.5</v></c><c r=\"D68\" t=\"n\"><v>1.5</v></c><c r=\"E68\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"69\"><c r=\"A69\" t=\"n\"><v>5.8</v></c><c r=\"B69\" t=\"n\"><v>2.7</v></c><c r=\"C69\" t=\"n\"><v>4.1</v></c><c r=\"D69\" t=\"n\"><v>1</v></c><c r=\"E69\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"70\"><c r=\"A70\" t=\"n\"><v>6.2</v></c><c r=\"B70\" t=\"n\"><v>2.2</v></c><c r=\"C70\" t=\"n\"><v>4.5</v></c><c r=\"D70\" t=\"n\"><v>1.5</v></c><c r=\"E70\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"71\"><c r=\"A71\" t=\"n\"><v>5.6</v></c><c r=\"B71\" t=\"n\"><v>2.5</v></c><c r=\"C71\" t=\"n\"><v>3.9</v></c><c r=\"D71\" t=\"n\"><v>1.1</v></c><c r=\"E71\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"72\"><c r=\"A72\" t=\"n\"><v>5.9</v></c><c r=\"B72\" t=\"n\"><v>3.2</v></c><c r=\"C72\" t=\"n\"><v>4.8</v></c><c r=\"D72\" t=\"n\"><v>1.8</v></c><c r=\"E72\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"73\"><c r=\"A73\" t=\"n\"><v>6.1</v></c><c r=\"B73\" t=\"n\"><v>2.8</v></c><c r=\"C73\" t=\"n\"><v>4</v></c><c r=\"D73\" t=\"n\"><v>1.3</v></c><c r=\"E73\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"74\"><c r=\"A74\" t=\"n\"><v>6.3</v></c><c r=\"B74\" t=\"n\"><v>2.5</v></c><c r=\"C74\" t=\"n\"><v>4.9</v></c><c r=\"D74\" t=\"n\"><v>1.5</v></c><c r=\"E74\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"75\"><c r=\"A75\" t=\"n\"><v>6.1</v></c><c r=\"B75\" t=\"n\"><v>2.8</v></c><c r=\"C75\" t=\"n\"><v>4.7</v></c><c r=\"D75\" t=\"n\"><v>1.2</v></c><c r=\"E75\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"76\"><c r=\"A76\" t=\"n\"><v>6.4</v></c><c r=\"B76\" t=\"n\"><v>2.9</v></c><c r=\"C76\" t=\"n\"><v>4.3</v></c><c r=\"D76\" t=\"n\"><v>1.3</v></c><c r=\"E76\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"77\"><c r=\"A77\" t=\"n\"><v>6.6</v></c><c r=\"B77\" t=\"n\"><v>3</v></c><c r=\"C77\" t=\"n\"><v>4.4</v></c><c r=\"D77\" t=\"n\"><v>1.4</v></c><c r=\"E77\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"78\"><c r=\"A78\" t=\"n\"><v>6.8</v></c><c r=\"B78\" t=\"n\"><v>2.8</v></c><c r=\"C78\" t=\"n\"><v>4.8</v></c><c r=\"D78\" t=\"n\"><v>1.4</v></c><c r=\"E78\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"79\"><c r=\"A79\" t=\"n\"><v>6.7</v></c><c r=\"B79\" t=\"n\"><v>3</v></c><c r=\"C79\" t=\"n\"><v>5</v></c><c r=\"D79\" t=\"n\"><v>1.7</v></c><c r=\"E79\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"80\"><c r=\"A80\" t=\"n\"><v>6</v></c><c r=\"B80\" t=\"n\"><v>2.9</v></c><c r=\"C80\" t=\"n\"><v>4.5</v></c><c r=\"D80\" t=\"n\"><v>1.5</v></c><c r=\"E80\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"81\"><c r=\"A81\" t=\"n\"><v>5.7</v></c><c r=\"B81\" t=\"n\"><v>2.6</v></c><c r=\"C81\" t=\"n\"><v>3.5</v></c><c r=\"D81\" t=\"n\"><v>1</v></c><c r=\"E81\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"82\"><c r=\"A82\" t=\"n\"><v>5.5</v></c><c r=\"B82\" t=\"n\"><v>2.4</v></c><c r=\"C82\" t=\"n\"><v>3.8</v></c><c r=\"D82\" t=\"n\"><v>1.1</v></c><c r=\"E82\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"83\"><c r=\"A83\" t=\"n\"><v>5.5</v></c><c r=\"B83\" t=\"n\"><v>2.4</v></c><c r=\"C83\" t=\"n\"><v>3.7</v></c><c r=\"D83\" t=\"n\"><v>1</v></c><c r=\"E83\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"84\"><c r=\"A84\" t=\"n\"><v>5.8</v></c><c r=\"B84\" t=\"n\"><v>2.7</v></c><c r=\"C84\" t=\"n\"><v>3.9</v></c><c r=\"D84\" t=\"n\"><v>1.2</v></c><c r=\"E84\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"85\"><c r=\"A85\" t=\"n\"><v>6</v></c><c r=\"B85\" t=\"n\"><v>2.7</v></c><c r=\"C85\" t=\"n\"><v>5.1</v></c><c r=\"D85\" t=\"n\"><v>1.6</v></c><c r=\"E85\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"86\"><c r=\"A86\" t=\"n\"><v>5.4</v></c><c r=\"B86\" t=\"n\"><v>3</v></c><c r=\"C86\" t=\"n\"><v>4.5</v></c><c r=\"D86\" t=\"n\"><v>1.5</v></c><c r=\"E86\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"87\"><c r=\"A87\" t=\"n\"><v>6</v></c><c r=\"B87\" t=\"n\"><v>3.4</v></c><c r=\"C87\" t=\"n\"><v>4.5</v></c><c r=\"D87\" t=\"n\"><v>1.6</v></c><c r=\"E87\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"88\"><c r=\"A88\" t=\"n\"><v>6.7</v></c><c r=\"B88\" t=\"n\"><v>3.1</v></c><c r=\"C88\" t=\"n\"><v>4.7</v></c><c r=\"D88\" t=\"n\"><v>1.5</v></c><c r=\"E88\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"89\"><c r=\"A89\" t=\"n\"><v>6.3</v></c><c r=\"B89\" t=\"n\"><v>2.3</v></c><c r=\"C89\" t=\"n\"><v>4.4</v></c><c r=\"D89\" t=\"n\"><v>1.3</v></c><c r=\"E89\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"90\"><c r=\"A90\" t=\"n\"><v>5.6</v></c><c r=\"B90\" t=\"n\"><v>3</v></c><c r=\"C90\" t=\"n\"><v>4.1</v></c><c r=\"D90\" t=\"n\"><v>1.3</v></c><c r=\"E90\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"91\"><c r=\"A91\" t=\"n\"><v>5.5</v></c><c r=\"B91\" t=\"n\"><v>2.5</v></c><c r=\"C91\" t=\"n\"><v>4</v></c><c r=\"D91\" t=\"n\"><v>1.3</v></c><c r=\"E91\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"92\"><c r=\"A92\" t=\"n\"><v>5.5</v></c><c r=\"B92\" t=\"n\"><v>2.6</v></c><c r=\"C92\" t=\"n\"><v>4.4</v></c><c r=\"D92\" t=\"n\"><v>1.2</v></c><c r=\"E92\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"93\"><c r=\"A93\" t=\"n\"><v>6.1</v></c><c r=\"B93\" t=\"n\"><v>3</v></c><c r=\"C93\" t=\"n\"><v>4.6</v></c><c r=\"D93\" t=\"n\"><v>1.4</v></c><c r=\"E93\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"94\"><c r=\"A94\" t=\"n\"><v>5.8</v></c><c r=\"B94\" t=\"n\"><v>2.6</v></c><c r=\"C94\" t=\"n\"><v>4</v></c><c r=\"D94\" t=\"n\"><v>1.2</v></c><c r=\"E94\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"95\"><c r=\"A95\" t=\"n\"><v>5</v></c><c r=\"B95\" t=\"n\"><v>2.3</v></c><c r=\"C95\" t=\"n\"><v>3.3</v></c><c r=\"D95\" t=\"n\"><v>1</v></c><c r=\"E95\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"96\"><c r=\"A96\" t=\"n\"><v>5.6</v></c><c r=\"B96\" t=\"n\"><v>2.7</v></c><c r=\"C96\" t=\"n\"><v>4.2</v></c><c r=\"D96\" t=\"n\"><v>1.3</v></c><c r=\"E96\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"97\"><c r=\"A97\" t=\"n\"><v>5.7</v></c><c r=\"B97\" t=\"n\"><v>3</v></c><c r=\"C97\" t=\"n\"><v>4.2</v></c><c r=\"D97\" t=\"n\"><v>1.2</v></c><c r=\"E97\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"98\"><c r=\"A98\" t=\"n\"><v>5.7</v></c><c r=\"B98\" t=\"n\"><v>2.9</v></c><c r=\"C98\" t=\"n\"><v>4.2</v></c><c r=\"D98\" t=\"n\"><v>1.3</v></c><c r=\"E98\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"99\"><c r=\"A99\" t=\"n\"><v>6.2</v></c><c r=\"B99\" t=\"n\"><v>2.9</v></c><c r=\"C99\" t=\"n\"><v>4.3</v></c><c r=\"D99\" t=\"n\"><v>1.3</v></c><c r=\"E99\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"100\"><c r=\"A100\" t=\"n\"><v>5.1</v></c><c r=\"B100\" t=\"n\"><v>2.5</v></c><c r=\"C100\" t=\"n\"><v>3</v></c><c r=\"D100\" t=\"n\"><v>1.1</v></c><c r=\"E100\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"101\"><c r=\"A101\" t=\"n\"><v>5.7</v></c><c r=\"B101\" t=\"n\"><v>2.8</v></c><c r=\"C101\" t=\"n\"><v>4.1</v></c><c r=\"D101\" t=\"n\"><v>1.3</v></c><c r=\"E101\" t=\"s\"><v>6</v></c></row>", 
                     "<row r=\"102\"><c r=\"A102\" t=\"n\"><v>6.3</v></c><c r=\"B102\" t=\"n\"><v>3.3</v></c><c r=\"C102\" t=\"n\"><v>6</v></c><c r=\"D102\" t=\"n\"><v>2.5</v></c><c r=\"E102\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"103\"><c r=\"A103\" t=\"n\"><v>5.8</v></c><c r=\"B103\" t=\"n\"><v>2.7</v></c><c r=\"C103\" t=\"n\"><v>5.1</v></c><c r=\"D103\" t=\"n\"><v>1.9</v></c><c r=\"E103\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"104\"><c r=\"A104\" t=\"n\"><v>7.1</v></c><c r=\"B104\" t=\"n\"><v>3</v></c><c r=\"C104\" t=\"n\"><v>5.9</v></c><c r=\"D104\" t=\"n\"><v>2.1</v></c><c r=\"E104\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"105\"><c r=\"A105\" t=\"n\"><v>6.3</v></c><c r=\"B105\" t=\"n\"><v>2.9</v></c><c r=\"C105\" t=\"n\"><v>5.6</v></c><c r=\"D105\" t=\"n\"><v>1.8</v></c><c r=\"E105\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"106\"><c r=\"A106\" t=\"n\"><v>6.5</v></c><c r=\"B106\" t=\"n\"><v>3</v></c><c r=\"C106\" t=\"n\"><v>5.8</v></c><c r=\"D106\" t=\"n\"><v>2.2</v></c><c r=\"E106\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"107\"><c r=\"A107\" t=\"n\"><v>7.6</v></c><c r=\"B107\" t=\"n\"><v>3</v></c><c r=\"C107\" t=\"n\"><v>6.6</v></c><c r=\"D107\" t=\"n\"><v>2.1</v></c><c r=\"E107\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"108\"><c r=\"A108\" t=\"n\"><v>4.9</v></c><c r=\"B108\" t=\"n\"><v>2.5</v></c><c r=\"C108\" t=\"n\"><v>4.5</v></c><c r=\"D108\" t=\"n\"><v>1.7</v></c><c r=\"E108\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"109\"><c r=\"A109\" t=\"n\"><v>7.3</v></c><c r=\"B109\" t=\"n\"><v>2.9</v></c><c r=\"C109\" t=\"n\"><v>6.3</v></c><c r=\"D109\" t=\"n\"><v>1.8</v></c><c r=\"E109\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"110\"><c r=\"A110\" t=\"n\"><v>6.7</v></c><c r=\"B110\" t=\"n\"><v>2.5</v></c><c r=\"C110\" t=\"n\"><v>5.8</v></c><c r=\"D110\" t=\"n\"><v>1.8</v></c><c r=\"E110\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"111\"><c r=\"A111\" t=\"n\"><v>7.2</v></c><c r=\"B111\" t=\"n\"><v>3.6</v></c><c r=\"C111\" t=\"n\"><v>6.1</v></c><c r=\"D111\" t=\"n\"><v>2.5</v></c><c r=\"E111\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"112\"><c r=\"A112\" t=\"n\"><v>6.5</v></c><c r=\"B112\" t=\"n\"><v>3.2</v></c><c r=\"C112\" t=\"n\"><v>5.1</v></c><c r=\"D112\" t=\"n\"><v>2</v></c><c r=\"E112\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"113\"><c r=\"A113\" t=\"n\"><v>6.4</v></c><c r=\"B113\" t=\"n\"><v>2.7</v></c><c r=\"C113\" t=\"n\"><v>5.3</v></c><c r=\"D113\" t=\"n\"><v>1.9</v></c><c r=\"E113\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"114\"><c r=\"A114\" t=\"n\"><v>6.8</v></c><c r=\"B114\" t=\"n\"><v>3</v></c><c r=\"C114\" t=\"n\"><v>5.5</v></c><c r=\"D114\" t=\"n\"><v>2.1</v></c><c r=\"E114\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"115\"><c r=\"A115\" t=\"n\"><v>5.7</v></c><c r=\"B115\" t=\"n\"><v>2.5</v></c><c r=\"C115\" t=\"n\"><v>5</v></c><c r=\"D115\" t=\"n\"><v>2</v></c><c r=\"E115\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"116\"><c r=\"A116\" t=\"n\"><v>5.8</v></c><c r=\"B116\" t=\"n\"><v>2.8</v></c><c r=\"C116\" t=\"n\"><v>5.1</v></c><c r=\"D116\" t=\"n\"><v>2.4</v></c><c r=\"E116\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"117\"><c r=\"A117\" t=\"n\"><v>6.4</v></c><c r=\"B117\" t=\"n\"><v>3.2</v></c><c r=\"C117\" t=\"n\"><v>5.3</v></c><c r=\"D117\" t=\"n\"><v>2.3</v></c><c r=\"E117\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"118\"><c r=\"A118\" t=\"n\"><v>6.5</v></c><c r=\"B118\" t=\"n\"><v>3</v></c><c r=\"C118\" t=\"n\"><v>5.5</v></c><c r=\"D118\" t=\"n\"><v>1.8</v></c><c r=\"E118\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"119\"><c r=\"A119\" t=\"n\"><v>7.7</v></c><c r=\"B119\" t=\"n\"><v>3.8</v></c><c r=\"C119\" t=\"n\"><v>6.7</v></c><c r=\"D119\" t=\"n\"><v>2.2</v></c><c r=\"E119\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"120\"><c r=\"A120\" t=\"n\"><v>7.7</v></c><c r=\"B120\" t=\"n\"><v>2.6</v></c><c r=\"C120\" t=\"n\"><v>6.9</v></c><c r=\"D120\" t=\"n\"><v>2.3</v></c><c r=\"E120\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"121\"><c r=\"A121\" t=\"n\"><v>6</v></c><c r=\"B121\" t=\"n\"><v>2.2</v></c><c r=\"C121\" t=\"n\"><v>5</v></c><c r=\"D121\" t=\"n\"><v>1.5</v></c><c r=\"E121\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"122\"><c r=\"A122\" t=\"n\"><v>6.9</v></c><c r=\"B122\" t=\"n\"><v>3.2</v></c><c r=\"C122\" t=\"n\"><v>5.7</v></c><c r=\"D122\" t=\"n\"><v>2.3</v></c><c r=\"E122\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"123\"><c r=\"A123\" t=\"n\"><v>5.6</v></c><c r=\"B123\" t=\"n\"><v>2.8</v></c><c r=\"C123\" t=\"n\"><v>4.9</v></c><c r=\"D123\" t=\"n\"><v>2</v></c><c r=\"E123\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"124\"><c r=\"A124\" t=\"n\"><v>7.7</v></c><c r=\"B124\" t=\"n\"><v>2.8</v></c><c r=\"C124\" t=\"n\"><v>6.7</v></c><c r=\"D124\" t=\"n\"><v>2</v></c><c r=\"E124\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"125\"><c r=\"A125\" t=\"n\"><v>6.3</v></c><c r=\"B125\" t=\"n\"><v>2.7</v></c><c r=\"C125\" t=\"n\"><v>4.9</v></c><c r=\"D125\" t=\"n\"><v>1.8</v></c><c r=\"E125\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"126\"><c r=\"A126\" t=\"n\"><v>6.7</v></c><c r=\"B126\" t=\"n\"><v>3.3</v></c><c r=\"C126\" t=\"n\"><v>5.7</v></c><c r=\"D126\" t=\"n\"><v>2.1</v></c><c r=\"E126\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"127\"><c r=\"A127\" t=\"n\"><v>7.2</v></c><c r=\"B127\" t=\"n\"><v>3.2</v></c><c r=\"C127\" t=\"n\"><v>6</v></c><c r=\"D127\" t=\"n\"><v>1.8</v></c><c r=\"E127\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"128\"><c r=\"A128\" t=\"n\"><v>6.2</v></c><c r=\"B128\" t=\"n\"><v>2.8</v></c><c r=\"C128\" t=\"n\"><v>4.8</v></c><c r=\"D128\" t=\"n\"><v>1.8</v></c><c r=\"E128\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"129\"><c r=\"A129\" t=\"n\"><v>6.1</v></c><c r=\"B129\" t=\"n\"><v>3</v></c><c r=\"C129\" t=\"n\"><v>4.9</v></c><c r=\"D129\" t=\"n\"><v>1.8</v></c><c r=\"E129\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"130\"><c r=\"A130\" t=\"n\"><v>6.4</v></c><c r=\"B130\" t=\"n\"><v>2.8</v></c><c r=\"C130\" t=\"n\"><v>5.6</v></c><c r=\"D130\" t=\"n\"><v>2.1</v></c><c r=\"E130\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"131\"><c r=\"A131\" t=\"n\"><v>7.2</v></c><c r=\"B131\" t=\"n\"><v>3</v></c><c r=\"C131\" t=\"n\"><v>5.8</v></c><c r=\"D131\" t=\"n\"><v>1.6</v></c><c r=\"E131\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"132\"><c r=\"A132\" t=\"n\"><v>7.4</v></c><c r=\"B132\" t=\"n\"><v>2.8</v></c><c r=\"C132\" t=\"n\"><v>6.1</v></c><c r=\"D132\" t=\"n\"><v>1.9</v></c><c r=\"E132\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"133\"><c r=\"A133\" t=\"n\"><v>7.9</v></c><c r=\"B133\" t=\"n\"><v>3.8</v></c><c r=\"C133\" t=\"n\"><v>6.4</v></c><c r=\"D133\" t=\"n\"><v>2</v></c><c r=\"E133\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"134\"><c r=\"A134\" t=\"n\"><v>6.4</v></c><c r=\"B134\" t=\"n\"><v>2.8</v></c><c r=\"C134\" t=\"n\"><v>5.6</v></c><c r=\"D134\" t=\"n\"><v>2.2</v></c><c r=\"E134\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"135\"><c r=\"A135\" t=\"n\"><v>6.3</v></c><c r=\"B135\" t=\"n\"><v>2.8</v></c><c r=\"C135\" t=\"n\"><v>5.1</v></c><c r=\"D135\" t=\"n\"><v>1.5</v></c><c r=\"E135\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"136\"><c r=\"A136\" t=\"n\"><v>6.1</v></c><c r=\"B136\" t=\"n\"><v>2.6</v></c><c r=\"C136\" t=\"n\"><v>5.6</v></c><c r=\"D136\" t=\"n\"><v>1.4</v></c><c r=\"E136\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"137\"><c r=\"A137\" t=\"n\"><v>7.7</v></c><c r=\"B137\" t=\"n\"><v>3</v></c><c r=\"C137\" t=\"n\"><v>6.1</v></c><c r=\"D137\" t=\"n\"><v>2.3</v></c><c r=\"E137\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"138\"><c r=\"A138\" t=\"n\"><v>6.3</v></c><c r=\"B138\" t=\"n\"><v>3.4</v></c><c r=\"C138\" t=\"n\"><v>5.6</v></c><c r=\"D138\" t=\"n\"><v>2.4</v></c><c r=\"E138\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"139\"><c r=\"A139\" t=\"n\"><v>6.4</v></c><c r=\"B139\" t=\"n\"><v>3.1</v></c><c r=\"C139\" t=\"n\"><v>5.5</v></c><c r=\"D139\" t=\"n\"><v>1.8</v></c><c r=\"E139\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"140\"><c r=\"A140\" t=\"n\"><v>6</v></c><c r=\"B140\" t=\"n\"><v>3</v></c><c r=\"C140\" t=\"n\"><v>4.8</v></c><c r=\"D140\" t=\"n\"><v>1.8</v></c><c r=\"E140\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"141\"><c r=\"A141\" t=\"n\"><v>6.9</v></c><c r=\"B141\" t=\"n\"><v>3.1</v></c><c r=\"C141\" t=\"n\"><v>5.4</v></c><c r=\"D141\" t=\"n\"><v>2.1</v></c><c r=\"E141\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"142\"><c r=\"A142\" t=\"n\"><v>6.7</v></c><c r=\"B142\" t=\"n\"><v>3.1</v></c><c r=\"C142\" t=\"n\"><v>5.6</v></c><c r=\"D142\" t=\"n\"><v>2.4</v></c><c r=\"E142\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"143\"><c r=\"A143\" t=\"n\"><v>6.9</v></c><c r=\"B143\" t=\"n\"><v>3.1</v></c><c r=\"C143\" t=\"n\"><v>5.1</v></c><c r=\"D143\" t=\"n\"><v>2.3</v></c><c r=\"E143\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"144\"><c r=\"A144\" t=\"n\"><v>5.8</v></c><c r=\"B144\" t=\"n\"><v>2.7</v></c><c r=\"C144\" t=\"n\"><v>5.1</v></c><c r=\"D144\" t=\"n\"><v>1.9</v></c><c r=\"E144\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"145\"><c r=\"A145\" t=\"n\"><v>6.8</v></c><c r=\"B145\" t=\"n\"><v>3.2</v></c><c r=\"C145\" t=\"n\"><v>5.9</v></c><c r=\"D145\" t=\"n\"><v>2.3</v></c><c r=\"E145\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"146\"><c r=\"A146\" t=\"n\"><v>6.7</v></c><c r=\"B146\" t=\"n\"><v>3.3</v></c><c r=\"C146\" t=\"n\"><v>5.7</v></c><c r=\"D146\" t=\"n\"><v>2.5</v></c><c r=\"E146\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"147\"><c r=\"A147\" t=\"n\"><v>6.7</v></c><c r=\"B147\" t=\"n\"><v>3</v></c><c r=\"C147\" t=\"n\"><v>5.2</v></c><c r=\"D147\" t=\"n\"><v>2.3</v></c><c r=\"E147\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"148\"><c r=\"A148\" t=\"n\"><v>6.3</v></c><c r=\"B148\" t=\"n\"><v>2.5</v></c><c r=\"C148\" t=\"n\"><v>5</v></c><c r=\"D148\" t=\"n\"><v>1.9</v></c><c r=\"E148\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"149\"><c r=\"A149\" t=\"n\"><v>6.5</v></c><c r=\"B149\" t=\"n\"><v>3</v></c><c r=\"C149\" t=\"n\"><v>5.2</v></c><c r=\"D149\" t=\"n\"><v>2</v></c><c r=\"E149\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"150\"><c r=\"A150\" t=\"n\"><v>6.2</v></c><c r=\"B150\" t=\"n\"><v>3.4</v></c><c r=\"C150\" t=\"n\"><v>5.4</v></c><c r=\"D150\" t=\"n\"><v>2.3</v></c><c r=\"E150\" t=\"s\"><v>7</v></c></row>", 
                     "<row r=\"151\"><c r=\"A151\" t=\"n\"><v>5.9</v></c><c r=\"B151\" t=\"n\"><v>3</v></c><c r=\"C151\" t=\"n\"><v>5.1</v></c><c r=\"D151\" t=\"n\"><v>1.8</v></c><c r=\"E151\" t=\"s\"><v>7</v></c></row>"
  )
  
  for(i in 1:length(expected_rows))
    expect_equal(rows[i], expected = expected_rows[i])
    
  
  unlink(x = temp_file)
  
  
})







test_that("Writing sheetData rows XML - mtcars", {
  
  temp_file <- tempfile(fileext = ".xlsx")
  openxlsx::write.xlsx(mtcars, temp_file, row.names = TRUE)
  
  unzip(temp_file, exdir = tempdir())
  x <- readLines(file.path(tempdir(), "xl", "worksheets", "sheet1.xml"), warn = FALSE, encoding = "UTF-8")
  rows <- unlist(regmatches(x = x, gregexpr("<row.*?</row>", x)))
  
  expected_rows <- c("<row r=\"1\"><c r=\"A1\" t=\"s\"><v>0</v></c><c r=\"B1\" t=\"s\"><v>1</v></c><c r=\"C1\" t=\"s\"><v>2</v></c><c r=\"D1\" t=\"s\"><v>3</v></c><c r=\"E1\" t=\"s\"><v>4</v></c><c r=\"F1\" t=\"s\"><v>5</v></c><c r=\"G1\" t=\"s\"><v>6</v></c><c r=\"H1\" t=\"s\"><v>7</v></c><c r=\"I1\" t=\"s\"><v>8</v></c><c r=\"J1\" t=\"s\"><v>9</v></c><c r=\"K1\" t=\"s\"><v>10</v></c><c r=\"L1\" t=\"s\"><v>11</v></c></row>", 
                     "<row r=\"2\"><c r=\"A2\" t=\"s\"><v>12</v></c><c r=\"B2\" t=\"n\"><v>21</v></c><c r=\"C2\" t=\"n\"><v>6</v></c><c r=\"D2\" t=\"n\"><v>160</v></c><c r=\"E2\" t=\"n\"><v>110</v></c><c r=\"F2\" t=\"n\"><v>3.9</v></c><c r=\"G2\" t=\"n\"><v>2.62</v></c><c r=\"H2\" t=\"n\"><v>16.46</v></c><c r=\"I2\" t=\"n\"><v>0</v></c><c r=\"J2\" t=\"n\"><v>1</v></c><c r=\"K2\" t=\"n\"><v>4</v></c><c r=\"L2\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"3\"><c r=\"A3\" t=\"s\"><v>13</v></c><c r=\"B3\" t=\"n\"><v>21</v></c><c r=\"C3\" t=\"n\"><v>6</v></c><c r=\"D3\" t=\"n\"><v>160</v></c><c r=\"E3\" t=\"n\"><v>110</v></c><c r=\"F3\" t=\"n\"><v>3.9</v></c><c r=\"G3\" t=\"n\"><v>2.875</v></c><c r=\"H3\" t=\"n\"><v>17.02</v></c><c r=\"I3\" t=\"n\"><v>0</v></c><c r=\"J3\" t=\"n\"><v>1</v></c><c r=\"K3\" t=\"n\"><v>4</v></c><c r=\"L3\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"4\"><c r=\"A4\" t=\"s\"><v>14</v></c><c r=\"B4\" t=\"n\"><v>22.8</v></c><c r=\"C4\" t=\"n\"><v>4</v></c><c r=\"D4\" t=\"n\"><v>108</v></c><c r=\"E4\" t=\"n\"><v>93</v></c><c r=\"F4\" t=\"n\"><v>3.85</v></c><c r=\"G4\" t=\"n\"><v>2.32</v></c><c r=\"H4\" t=\"n\"><v>18.61</v></c><c r=\"I4\" t=\"n\"><v>1</v></c><c r=\"J4\" t=\"n\"><v>1</v></c><c r=\"K4\" t=\"n\"><v>4</v></c><c r=\"L4\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"5\"><c r=\"A5\" t=\"s\"><v>15</v></c><c r=\"B5\" t=\"n\"><v>21.4</v></c><c r=\"C5\" t=\"n\"><v>6</v></c><c r=\"D5\" t=\"n\"><v>258</v></c><c r=\"E5\" t=\"n\"><v>110</v></c><c r=\"F5\" t=\"n\"><v>3.08</v></c><c r=\"G5\" t=\"n\"><v>3.215</v></c><c r=\"H5\" t=\"n\"><v>19.44</v></c><c r=\"I5\" t=\"n\"><v>1</v></c><c r=\"J5\" t=\"n\"><v>0</v></c><c r=\"K5\" t=\"n\"><v>3</v></c><c r=\"L5\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"6\"><c r=\"A6\" t=\"s\"><v>16</v></c><c r=\"B6\" t=\"n\"><v>18.7</v></c><c r=\"C6\" t=\"n\"><v>8</v></c><c r=\"D6\" t=\"n\"><v>360</v></c><c r=\"E6\" t=\"n\"><v>175</v></c><c r=\"F6\" t=\"n\"><v>3.15</v></c><c r=\"G6\" t=\"n\"><v>3.44</v></c><c r=\"H6\" t=\"n\"><v>17.02</v></c><c r=\"I6\" t=\"n\"><v>0</v></c><c r=\"J6\" t=\"n\"><v>0</v></c><c r=\"K6\" t=\"n\"><v>3</v></c><c r=\"L6\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"7\"><c r=\"A7\" t=\"s\"><v>17</v></c><c r=\"B7\" t=\"n\"><v>18.1</v></c><c r=\"C7\" t=\"n\"><v>6</v></c><c r=\"D7\" t=\"n\"><v>225</v></c><c r=\"E7\" t=\"n\"><v>105</v></c><c r=\"F7\" t=\"n\"><v>2.76</v></c><c r=\"G7\" t=\"n\"><v>3.46</v></c><c r=\"H7\" t=\"n\"><v>20.22</v></c><c r=\"I7\" t=\"n\"><v>1</v></c><c r=\"J7\" t=\"n\"><v>0</v></c><c r=\"K7\" t=\"n\"><v>3</v></c><c r=\"L7\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"8\"><c r=\"A8\" t=\"s\"><v>18</v></c><c r=\"B8\" t=\"n\"><v>14.3</v></c><c r=\"C8\" t=\"n\"><v>8</v></c><c r=\"D8\" t=\"n\"><v>360</v></c><c r=\"E8\" t=\"n\"><v>245</v></c><c r=\"F8\" t=\"n\"><v>3.21</v></c><c r=\"G8\" t=\"n\"><v>3.57</v></c><c r=\"H8\" t=\"n\"><v>15.84</v></c><c r=\"I8\" t=\"n\"><v>0</v></c><c r=\"J8\" t=\"n\"><v>0</v></c><c r=\"K8\" t=\"n\"><v>3</v></c><c r=\"L8\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"9\"><c r=\"A9\" t=\"s\"><v>19</v></c><c r=\"B9\" t=\"n\"><v>24.4</v></c><c r=\"C9\" t=\"n\"><v>4</v></c><c r=\"D9\" t=\"n\"><v>146.7</v></c><c r=\"E9\" t=\"n\"><v>62</v></c><c r=\"F9\" t=\"n\"><v>3.69</v></c><c r=\"G9\" t=\"n\"><v>3.19</v></c><c r=\"H9\" t=\"n\"><v>20</v></c><c r=\"I9\" t=\"n\"><v>1</v></c><c r=\"J9\" t=\"n\"><v>0</v></c><c r=\"K9\" t=\"n\"><v>4</v></c><c r=\"L9\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"10\"><c r=\"A10\" t=\"s\"><v>20</v></c><c r=\"B10\" t=\"n\"><v>22.8</v></c><c r=\"C10\" t=\"n\"><v>4</v></c><c r=\"D10\" t=\"n\"><v>140.8</v></c><c r=\"E10\" t=\"n\"><v>95</v></c><c r=\"F10\" t=\"n\"><v>3.92</v></c><c r=\"G10\" t=\"n\"><v>3.15</v></c><c r=\"H10\" t=\"n\"><v>22.9</v></c><c r=\"I10\" t=\"n\"><v>1</v></c><c r=\"J10\" t=\"n\"><v>0</v></c><c r=\"K10\" t=\"n\"><v>4</v></c><c r=\"L10\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"11\"><c r=\"A11\" t=\"s\"><v>21</v></c><c r=\"B11\" t=\"n\"><v>19.2</v></c><c r=\"C11\" t=\"n\"><v>6</v></c><c r=\"D11\" t=\"n\"><v>167.6</v></c><c r=\"E11\" t=\"n\"><v>123</v></c><c r=\"F11\" t=\"n\"><v>3.92</v></c><c r=\"G11\" t=\"n\"><v>3.44</v></c><c r=\"H11\" t=\"n\"><v>18.3</v></c><c r=\"I11\" t=\"n\"><v>1</v></c><c r=\"J11\" t=\"n\"><v>0</v></c><c r=\"K11\" t=\"n\"><v>4</v></c><c r=\"L11\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"12\"><c r=\"A12\" t=\"s\"><v>22</v></c><c r=\"B12\" t=\"n\"><v>17.8</v></c><c r=\"C12\" t=\"n\"><v>6</v></c><c r=\"D12\" t=\"n\"><v>167.6</v></c><c r=\"E12\" t=\"n\"><v>123</v></c><c r=\"F12\" t=\"n\"><v>3.92</v></c><c r=\"G12\" t=\"n\"><v>3.44</v></c><c r=\"H12\" t=\"n\"><v>18.9</v></c><c r=\"I12\" t=\"n\"><v>1</v></c><c r=\"J12\" t=\"n\"><v>0</v></c><c r=\"K12\" t=\"n\"><v>4</v></c><c r=\"L12\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"13\"><c r=\"A13\" t=\"s\"><v>23</v></c><c r=\"B13\" t=\"n\"><v>16.4</v></c><c r=\"C13\" t=\"n\"><v>8</v></c><c r=\"D13\" t=\"n\"><v>275.8</v></c><c r=\"E13\" t=\"n\"><v>180</v></c><c r=\"F13\" t=\"n\"><v>3.07</v></c><c r=\"G13\" t=\"n\"><v>4.07</v></c><c r=\"H13\" t=\"n\"><v>17.4</v></c><c r=\"I13\" t=\"n\"><v>0</v></c><c r=\"J13\" t=\"n\"><v>0</v></c><c r=\"K13\" t=\"n\"><v>3</v></c><c r=\"L13\" t=\"n\"><v>3</v></c></row>", 
                     "<row r=\"14\"><c r=\"A14\" t=\"s\"><v>24</v></c><c r=\"B14\" t=\"n\"><v>17.3</v></c><c r=\"C14\" t=\"n\"><v>8</v></c><c r=\"D14\" t=\"n\"><v>275.8</v></c><c r=\"E14\" t=\"n\"><v>180</v></c><c r=\"F14\" t=\"n\"><v>3.07</v></c><c r=\"G14\" t=\"n\"><v>3.73</v></c><c r=\"H14\" t=\"n\"><v>17.6</v></c><c r=\"I14\" t=\"n\"><v>0</v></c><c r=\"J14\" t=\"n\"><v>0</v></c><c r=\"K14\" t=\"n\"><v>3</v></c><c r=\"L14\" t=\"n\"><v>3</v></c></row>", 
                     "<row r=\"15\"><c r=\"A15\" t=\"s\"><v>25</v></c><c r=\"B15\" t=\"n\"><v>15.2</v></c><c r=\"C15\" t=\"n\"><v>8</v></c><c r=\"D15\" t=\"n\"><v>275.8</v></c><c r=\"E15\" t=\"n\"><v>180</v></c><c r=\"F15\" t=\"n\"><v>3.07</v></c><c r=\"G15\" t=\"n\"><v>3.78</v></c><c r=\"H15\" t=\"n\"><v>18</v></c><c r=\"I15\" t=\"n\"><v>0</v></c><c r=\"J15\" t=\"n\"><v>0</v></c><c r=\"K15\" t=\"n\"><v>3</v></c><c r=\"L15\" t=\"n\"><v>3</v></c></row>", 
                     "<row r=\"16\"><c r=\"A16\" t=\"s\"><v>26</v></c><c r=\"B16\" t=\"n\"><v>10.4</v></c><c r=\"C16\" t=\"n\"><v>8</v></c><c r=\"D16\" t=\"n\"><v>472</v></c><c r=\"E16\" t=\"n\"><v>205</v></c><c r=\"F16\" t=\"n\"><v>2.93</v></c><c r=\"G16\" t=\"n\"><v>5.25</v></c><c r=\"H16\" t=\"n\"><v>17.98</v></c><c r=\"I16\" t=\"n\"><v>0</v></c><c r=\"J16\" t=\"n\"><v>0</v></c><c r=\"K16\" t=\"n\"><v>3</v></c><c r=\"L16\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"17\"><c r=\"A17\" t=\"s\"><v>27</v></c><c r=\"B17\" t=\"n\"><v>10.4</v></c><c r=\"C17\" t=\"n\"><v>8</v></c><c r=\"D17\" t=\"n\"><v>460</v></c><c r=\"E17\" t=\"n\"><v>215</v></c><c r=\"F17\" t=\"n\"><v>3</v></c><c r=\"G17\" t=\"n\"><v>5.424</v></c><c r=\"H17\" t=\"n\"><v>17.82</v></c><c r=\"I17\" t=\"n\"><v>0</v></c><c r=\"J17\" t=\"n\"><v>0</v></c><c r=\"K17\" t=\"n\"><v>3</v></c><c r=\"L17\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"18\"><c r=\"A18\" t=\"s\"><v>28</v></c><c r=\"B18\" t=\"n\"><v>14.7</v></c><c r=\"C18\" t=\"n\"><v>8</v></c><c r=\"D18\" t=\"n\"><v>440</v></c><c r=\"E18\" t=\"n\"><v>230</v></c><c r=\"F18\" t=\"n\"><v>3.23</v></c><c r=\"G18\" t=\"n\"><v>5.345</v></c><c r=\"H18\" t=\"n\"><v>17.42</v></c><c r=\"I18\" t=\"n\"><v>0</v></c><c r=\"J18\" t=\"n\"><v>0</v></c><c r=\"K18\" t=\"n\"><v>3</v></c><c r=\"L18\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"19\"><c r=\"A19\" t=\"s\"><v>29</v></c><c r=\"B19\" t=\"n\"><v>32.4</v></c><c r=\"C19\" t=\"n\"><v>4</v></c><c r=\"D19\" t=\"n\"><v>78.7</v></c><c r=\"E19\" t=\"n\"><v>66</v></c><c r=\"F19\" t=\"n\"><v>4.08</v></c><c r=\"G19\" t=\"n\"><v>2.2</v></c><c r=\"H19\" t=\"n\"><v>19.47</v></c><c r=\"I19\" t=\"n\"><v>1</v></c><c r=\"J19\" t=\"n\"><v>1</v></c><c r=\"K19\" t=\"n\"><v>4</v></c><c r=\"L19\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"20\"><c r=\"A20\" t=\"s\"><v>30</v></c><c r=\"B20\" t=\"n\"><v>30.4</v></c><c r=\"C20\" t=\"n\"><v>4</v></c><c r=\"D20\" t=\"n\"><v>75.7</v></c><c r=\"E20\" t=\"n\"><v>52</v></c><c r=\"F20\" t=\"n\"><v>4.93</v></c><c r=\"G20\" t=\"n\"><v>1.615</v></c><c r=\"H20\" t=\"n\"><v>18.52</v></c><c r=\"I20\" t=\"n\"><v>1</v></c><c r=\"J20\" t=\"n\"><v>1</v></c><c r=\"K20\" t=\"n\"><v>4</v></c><c r=\"L20\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"21\"><c r=\"A21\" t=\"s\"><v>31</v></c><c r=\"B21\" t=\"n\"><v>33.9</v></c><c r=\"C21\" t=\"n\"><v>4</v></c><c r=\"D21\" t=\"n\"><v>71.1</v></c><c r=\"E21\" t=\"n\"><v>65</v></c><c r=\"F21\" t=\"n\"><v>4.22</v></c><c r=\"G21\" t=\"n\"><v>1.835</v></c><c r=\"H21\" t=\"n\"><v>19.9</v></c><c r=\"I21\" t=\"n\"><v>1</v></c><c r=\"J21\" t=\"n\"><v>1</v></c><c r=\"K21\" t=\"n\"><v>4</v></c><c r=\"L21\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"22\"><c r=\"A22\" t=\"s\"><v>32</v></c><c r=\"B22\" t=\"n\"><v>21.5</v></c><c r=\"C22\" t=\"n\"><v>4</v></c><c r=\"D22\" t=\"n\"><v>120.1</v></c><c r=\"E22\" t=\"n\"><v>97</v></c><c r=\"F22\" t=\"n\"><v>3.7</v></c><c r=\"G22\" t=\"n\"><v>2.465</v></c><c r=\"H22\" t=\"n\"><v>20.01</v></c><c r=\"I22\" t=\"n\"><v>1</v></c><c r=\"J22\" t=\"n\"><v>0</v></c><c r=\"K22\" t=\"n\"><v>3</v></c><c r=\"L22\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"23\"><c r=\"A23\" t=\"s\"><v>33</v></c><c r=\"B23\" t=\"n\"><v>15.5</v></c><c r=\"C23\" t=\"n\"><v>8</v></c><c r=\"D23\" t=\"n\"><v>318</v></c><c r=\"E23\" t=\"n\"><v>150</v></c><c r=\"F23\" t=\"n\"><v>2.76</v></c><c r=\"G23\" t=\"n\"><v>3.52</v></c><c r=\"H23\" t=\"n\"><v>16.87</v></c><c r=\"I23\" t=\"n\"><v>0</v></c><c r=\"J23\" t=\"n\"><v>0</v></c><c r=\"K23\" t=\"n\"><v>3</v></c><c r=\"L23\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"24\"><c r=\"A24\" t=\"s\"><v>34</v></c><c r=\"B24\" t=\"n\"><v>15.2</v></c><c r=\"C24\" t=\"n\"><v>8</v></c><c r=\"D24\" t=\"n\"><v>304</v></c><c r=\"E24\" t=\"n\"><v>150</v></c><c r=\"F24\" t=\"n\"><v>3.15</v></c><c r=\"G24\" t=\"n\"><v>3.435</v></c><c r=\"H24\" t=\"n\"><v>17.3</v></c><c r=\"I24\" t=\"n\"><v>0</v></c><c r=\"J24\" t=\"n\"><v>0</v></c><c r=\"K24\" t=\"n\"><v>3</v></c><c r=\"L24\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"25\"><c r=\"A25\" t=\"s\"><v>35</v></c><c r=\"B25\" t=\"n\"><v>13.3</v></c><c r=\"C25\" t=\"n\"><v>8</v></c><c r=\"D25\" t=\"n\"><v>350</v></c><c r=\"E25\" t=\"n\"><v>245</v></c><c r=\"F25\" t=\"n\"><v>3.73</v></c><c r=\"G25\" t=\"n\"><v>3.84</v></c><c r=\"H25\" t=\"n\"><v>15.41</v></c><c r=\"I25\" t=\"n\"><v>0</v></c><c r=\"J25\" t=\"n\"><v>0</v></c><c r=\"K25\" t=\"n\"><v>3</v></c><c r=\"L25\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"26\"><c r=\"A26\" t=\"s\"><v>36</v></c><c r=\"B26\" t=\"n\"><v>19.2</v></c><c r=\"C26\" t=\"n\"><v>8</v></c><c r=\"D26\" t=\"n\"><v>400</v></c><c r=\"E26\" t=\"n\"><v>175</v></c><c r=\"F26\" t=\"n\"><v>3.08</v></c><c r=\"G26\" t=\"n\"><v>3.845</v></c><c r=\"H26\" t=\"n\"><v>17.05</v></c><c r=\"I26\" t=\"n\"><v>0</v></c><c r=\"J26\" t=\"n\"><v>0</v></c><c r=\"K26\" t=\"n\"><v>3</v></c><c r=\"L26\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"27\"><c r=\"A27\" t=\"s\"><v>37</v></c><c r=\"B27\" t=\"n\"><v>27.3</v></c><c r=\"C27\" t=\"n\"><v>4</v></c><c r=\"D27\" t=\"n\"><v>79</v></c><c r=\"E27\" t=\"n\"><v>66</v></c><c r=\"F27\" t=\"n\"><v>4.08</v></c><c r=\"G27\" t=\"n\"><v>1.935</v></c><c r=\"H27\" t=\"n\"><v>18.9</v></c><c r=\"I27\" t=\"n\"><v>1</v></c><c r=\"J27\" t=\"n\"><v>1</v></c><c r=\"K27\" t=\"n\"><v>4</v></c><c r=\"L27\" t=\"n\"><v>1</v></c></row>", 
                     "<row r=\"28\"><c r=\"A28\" t=\"s\"><v>38</v></c><c r=\"B28\" t=\"n\"><v>26</v></c><c r=\"C28\" t=\"n\"><v>4</v></c><c r=\"D28\" t=\"n\"><v>120.3</v></c><c r=\"E28\" t=\"n\"><v>91</v></c><c r=\"F28\" t=\"n\"><v>4.43</v></c><c r=\"G28\" t=\"n\"><v>2.14</v></c><c r=\"H28\" t=\"n\"><v>16.7</v></c><c r=\"I28\" t=\"n\"><v>0</v></c><c r=\"J28\" t=\"n\"><v>1</v></c><c r=\"K28\" t=\"n\"><v>5</v></c><c r=\"L28\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"29\"><c r=\"A29\" t=\"s\"><v>39</v></c><c r=\"B29\" t=\"n\"><v>30.4</v></c><c r=\"C29\" t=\"n\"><v>4</v></c><c r=\"D29\" t=\"n\"><v>95.1</v></c><c r=\"E29\" t=\"n\"><v>113</v></c><c r=\"F29\" t=\"n\"><v>3.77</v></c><c r=\"G29\" t=\"n\"><v>1.513</v></c><c r=\"H29\" t=\"n\"><v>16.9</v></c><c r=\"I29\" t=\"n\"><v>1</v></c><c r=\"J29\" t=\"n\"><v>1</v></c><c r=\"K29\" t=\"n\"><v>5</v></c><c r=\"L29\" t=\"n\"><v>2</v></c></row>", 
                     "<row r=\"30\"><c r=\"A30\" t=\"s\"><v>40</v></c><c r=\"B30\" t=\"n\"><v>15.8</v></c><c r=\"C30\" t=\"n\"><v>8</v></c><c r=\"D30\" t=\"n\"><v>351</v></c><c r=\"E30\" t=\"n\"><v>264</v></c><c r=\"F30\" t=\"n\"><v>4.22</v></c><c r=\"G30\" t=\"n\"><v>3.17</v></c><c r=\"H30\" t=\"n\"><v>14.5</v></c><c r=\"I30\" t=\"n\"><v>0</v></c><c r=\"J30\" t=\"n\"><v>1</v></c><c r=\"K30\" t=\"n\"><v>5</v></c><c r=\"L30\" t=\"n\"><v>4</v></c></row>", 
                     "<row r=\"31\"><c r=\"A31\" t=\"s\"><v>41</v></c><c r=\"B31\" t=\"n\"><v>19.7</v></c><c r=\"C31\" t=\"n\"><v>6</v></c><c r=\"D31\" t=\"n\"><v>145</v></c><c r=\"E31\" t=\"n\"><v>175</v></c><c r=\"F31\" t=\"n\"><v>3.62</v></c><c r=\"G31\" t=\"n\"><v>2.77</v></c><c r=\"H31\" t=\"n\"><v>15.5</v></c><c r=\"I31\" t=\"n\"><v>0</v></c><c r=\"J31\" t=\"n\"><v>1</v></c><c r=\"K31\" t=\"n\"><v>5</v></c><c r=\"L31\" t=\"n\"><v>6</v></c></row>", 
                     "<row r=\"32\"><c r=\"A32\" t=\"s\"><v>42</v></c><c r=\"B32\" t=\"n\"><v>15</v></c><c r=\"C32\" t=\"n\"><v>8</v></c><c r=\"D32\" t=\"n\"><v>301</v></c><c r=\"E32\" t=\"n\"><v>335</v></c><c r=\"F32\" t=\"n\"><v>3.54</v></c><c r=\"G32\" t=\"n\"><v>3.57</v></c><c r=\"H32\" t=\"n\"><v>14.6</v></c><c r=\"I32\" t=\"n\"><v>0</v></c><c r=\"J32\" t=\"n\"><v>1</v></c><c r=\"K32\" t=\"n\"><v>5</v></c><c r=\"L32\" t=\"n\"><v>8</v></c></row>", 
                     "<row r=\"33\"><c r=\"A33\" t=\"s\"><v>43</v></c><c r=\"B33\" t=\"n\"><v>21.4</v></c><c r=\"C33\" t=\"n\"><v>4</v></c><c r=\"D33\" t=\"n\"><v>121</v></c><c r=\"E33\" t=\"n\"><v>109</v></c><c r=\"F33\" t=\"n\"><v>4.11</v></c><c r=\"G33\" t=\"n\"><v>2.78</v></c><c r=\"H33\" t=\"n\"><v>18.6</v></c><c r=\"I33\" t=\"n\"><v>1</v></c><c r=\"J33\" t=\"n\"><v>1</v></c><c r=\"K33\" t=\"n\"><v>4</v></c><c r=\"L33\" t=\"n\"><v>2</v></c></row>"
  )
  
  for(i in 1:length(expected_rows))
    expect_equal(rows[i], expected = expected_rows[i])
  
  
  
})
