% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-config.R
\name{otp_validate_config}
\alias{otp_validate_config}
\title{Validate Config Object}
\usage{
otp_validate_config(config, type = attributes(config)$config_type)
}
\arguments{
\item{config}{A named list made/modified from `otp_make_config()`}

\item{type}{type of config file}
}
\description{
Checks if the list of OTP configuration options is valid
}
\details{
Performs basic validity checks on class, max/min values etc as appropriate,
some of more complex parameters are not checked. For more details see:

http://docs.opentripplanner.org/en/latest/Configuration
http://dev.opentripplanner.org/javadoc/1.3.0/org/opentripplanner/routing/core/RoutingRequest.html
}
\examples{
\dontrun{
conf <- otp_make_config("build")
otp_validate_config(conf)
}
}
\seealso{
Other setup: 
\code{\link{otp_build_graph}()},
\code{\link{otp_check_java}()},
\code{\link{otp_dl_demo}()},
\code{\link{otp_dl_jar}()},
\code{\link{otp_make_config}()},
\code{\link{otp_setup}()},
\code{\link{otp_stop}()},
\code{\link{otp_write_config}()}
}
\concept{setup}
