% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-isochrone-batch.R
\name{otp_isochrone}
\alias{otp_isochrone}
\title{Get the Isochrones from a location}
\usage{
otp_isochrone(
  otpcon = NA,
  fromPlace = NA,
  fromID = NULL,
  mode = "TRANSIT",
  date_time = Sys.time(),
  arriveBy = FALSE,
  maxWalkDistance = 1000,
  routingOptions = NULL,
  cutoffSec = c(600, 1200, 1800, 2400, 3000, 3600),
  ncores = 1,
  timezone = otpcon$timezone
)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{fromPlace}{Numeric vector, Longitude/Latitude pair,
    e.g. `c(-0.134649,51.529258)`,
or 2 column matrix of Longitude/Latitude pairs, or sf
    data frame of POINTS}

\item{fromID}{character vector same length as fromPlace}

\item{mode}{character vector of one or more modes of travel valid values
TRANSIT, WALK, BICYCLE, CAR, BUS, RAIL, default CAR. Not all
combinations are valid e.g. c("WALK","BUS") is valid but
c("WALK","CAR") is not.}

\item{date_time}{POSIXct, a date and time, defaults to current
date and time}

\item{arriveBy}{Logical, Whether the trip should depart or
arrive at the specified date and time, default FALSE}

\item{maxWalkDistance}{maximum distance to walk in metres}

\item{routingOptions}{named list passed to OTP see `otp_routing_options()`}

\item{cutoffSec}{Numeric vector, number of seconds to define
the break points of each Isochrone}

\item{ncores}{number of cores to use in parallel processing}

\item{timezone}{character, timezone to use, default from otpcon}
}
\value{
Returns a SF data.frame of POLYGONs
}
\description{
Get the Isochrones from a location
}
\details{
Isochrones are maps of equal travel time,
for a given location a map is produced showing how long it takes to reach
each location.
}
\examples{
\dontrun{
isochrone1 <- otp_isochrone(otpcon, fromPlace = c(-0.1346, 51.5292))
isochrone2 <- otp_isochrone(otpcon,
  fromPlace = c(-0.1346, 51.5292),
  mode = c("WALK", "TRANSIT"), cutoffSec = c(600, 1200, 1800)
)
}
}
\seealso{
Other routing: 
\code{\link{otp_geocode}()},
\code{\link{otp_plan}()},
\code{\link{otp_routing_options}()},
\code{\link{otp_validate_routing_options}()}
}
\concept{routing}
