% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{get_current_channel_vu_left}
\alias{get_current_channel_vu_left}
\alias{get_current_channel_vu_mono}
\alias{get_current_channel_vu_rear_left}
\alias{get_current_channel_vu_rear_right}
\alias{get_current_channel_vu_right}
\alias{get_current_estimated_bpm}
\alias{get_current_order}
\alias{get_current_pattern}
\alias{get_current_playing_channels}
\alias{get_current_row}
\alias{get_current_speed}
\alias{get_current_tempo}
\title{Get the state of specific aspects of an \code{openmpt} class object}
\usage{
get_current_channel_vu_left(mod, channel, ...)

get_current_channel_vu_mono(mod, channel, ...)

get_current_channel_vu_rear_left(mod, channel, ...)

get_current_channel_vu_rear_right(mod, channel, ...)

get_current_channel_vu_right(mod, channel, ...)

get_current_estimated_bpm(mod, ...)

get_current_order(mod, ...)

get_current_pattern(mod, ...)

get_current_playing_channels(mod, ...)

get_current_row(mod, ...)

get_current_speed(mod, ...)

get_current_tempo(mod, ...)
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{channel}{An \code{integer} channel index (starting at 0), for which
to get the current state.}

\item{...}{Ignored}
}
\value{
Return \code{numeric} or \code{integer} values of the requested state.
Function names are pretty self-explanatory. Note that tempo and speed
values are tracker dependent, their meaning depend on the originating
tracker.
}
\description{
While playing with \code{\link[=play]{play()}} or rendering with \code{\link[=convert_mod]{convert_mod()}}, the
state of the module can change continuously (volume, speed, order index, etc.).
These functions return the
current state of an \code{openmpt} class object.
}
\examples{
mod <- demo_mod()

get_current_channel_vu_left(mod, 0L)
get_current_channel_vu_mono(mod, 0L)
get_current_channel_vu_rear_left(mod, 0L)
get_current_channel_vu_rear_right(mod, 0L)
get_current_channel_vu_right(mod, 0L)
get_current_estimated_bpm(mod)
get_current_order(mod)
get_current_pattern(mod)
get_current_playing_channels(mod)
get_current_row(mod)
get_current_speed(mod)
get_current_tempo(mod)
}
