% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_list_events.R
\name{oc_list_events}
\alias{oc_list_events}
\title{Query Opencast for a list of events}
\usage{
oc_list_events(
  sign = FALSE,
  withacl = FALSE,
  withmetadata = FALSE,
  withscheduling = FALSE,
  withpublications = FALSE,
  filter = "",
  sort = "",
  limit = 0,
  offset = 0
)
}
\arguments{
\item{sign}{Whether public distribution urls should be signed.}

\item{withacl}{Whether the acl metadata should be included in the response.}

\item{withmetadata}{Whether the metadata catalogs should be included in the response.}

\item{withscheduling}{Whether the scheduling information should be included in the response.}

\item{withpublications}{Whether the publication ids and urls should be included in the response.}

\item{filter}{A comma seperated list of filters to limit the results with. A filter is the filter's name followed by a colon ":" and then the value to filter with so it is the form :.}

\item{sort}{Sort the results based upon a list of comma seperated sorting criteria. In the comma seperated list each type of sorting is specified as a pair such as: :ASC or :DESC. Adding the suffix ASC or DESC sets the order as ascending or descending order and is mandatory.}

\item{limit}{The maximum number of results to return for a single request.}

\item{offset}{The index of the first result to return.}
}
\value{
Returns a list of events.
}
\description{
Returns a list of events.
}
\details{
This function expects the hostname, username and password to be set as environment variables.
}
\examples{
Sys.setenv(OPENCAST_HOST = "https://legacy.opencast.org")
Sys.setenv(OPENCAST_USERNAME = "admin")
Sys.setenv(OPENCAST_PASSWORD = "opencast")

oc_list_events()
}
